/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.arch.gui.EmoteMenuImpl;
import io.github.kosmx.emotes.arch.gui.screen.ingame.FastChosseScreen;
import io.github.kosmx.emotes.forge.executor.ForgeClientMethods;
import io.github.kosmx.emotes.forge.network.ClientNetworkInstance;
import io.github.kosmx.emotes.main.MainClientInit;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientInit {
    static KeyMapping openMenuKey;
    static KeyMapping stopEmote;
    static KeyMapping debugKey;
    static Consumer<Minecraft> keyBindingFunction;

    static void initClient() {
        ClientInit.initKeyBinding();
        ClientNetworkInstance.networkInstance.init();
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((minecraft, screen) -> new EmoteMenuImpl((Screen)screen)));
    }

    @SubscribeEvent
    public static void endClientTick(TickEvent.ClientTickEvent event) {
        ++ForgeClientMethods.tick;
    }

    @SubscribeEvent
    public static void keyListenerEvent(InputEvent.KeyInputEvent event) {
        keyBindingFunction.accept(null);
    }

    private static void initKeyBinding() {
        openMenuKey = new KeyMapping("key.emotecraft.fastchoose", InputConstants.Type.KEYSYM, 66, "category.emotecraft.keybinding");
        ClientRegistry.registerKeyBinding((KeyMapping)openMenuKey);
        stopEmote = new KeyMapping("key.emotecraft.stop", InputConstants.Type.KEYSYM, -1, "category.emotecraft.keybinding");
        ClientRegistry.registerKeyBinding((KeyMapping)stopEmote);
        if (FMLLoader.getGamePath().resolve("emote.json").toFile().isFile()) {
            debugKey = new KeyMapping("key.emotecraft.debug", InputConstants.Type.KEYSYM, 79, "category.emotecraft.keybinding");
            ClientRegistry.registerKeyBinding((KeyMapping)debugKey);
        }
        keyBindingFunction = client -> {
            if (openMenuKey.m_90859_() && Minecraft.m_91087_().f_91074_ == Minecraft.m_91087_().m_91288_()) {
                Minecraft.m_91087_().m_91152_((Screen)new FastChosseScreen(null));
            }
            if (stopEmote.m_90859_()) {
                ClientEmotePlay.clientStopLocalEmote();
            }
            if (debugKey != null && debugKey.m_90859_()) {
                MainClientInit.playDebugEmote();
            }
        };
    }
}

