/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.playerAnim.impl;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.common.tools.Vec3f;
import io.github.kosmx.playerAnim.TransformType;
import io.github.kosmx.playerAnim.layered.IAnimation;

public class AnimationPlayer {
    private final IAnimation animation;
    private float tickDelta = 0.0f;

    public AnimationPlayer(IAnimation animation) {
        this.animation = animation;
    }

    public void tick() {
        this.animation.tick();
    }

    public boolean isActive() {
        return this.animation.isActive();
    }

    public Vec3f get3DTransform(String modelName, TransformType type, Vec3f value0) {
        return this.animation.get3DTransform(modelName, type, this.tickDelta, value0);
    }

    public void setTickDelta(float tickDelta) {
        this.tickDelta = tickDelta;
        this.animation.setupAnim(tickDelta);
    }

    public Pair<Float, Float> getBend(String modelName) {
        Vec3f bendVec = this.get3DTransform(modelName, TransformType.BEND, Vec3f.ZERO);
        return new Pair<Float, Float>((Float)bendVec.getX(), (Float)bendVec.getY());
    }
}

