/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyTalents2;
import doggytalents.client.block.model.DogBedModel;
import doggytalents.client.screen.widget.DogInventoryButton;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.OpenDogScreenData;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ClientEventHandler {
    public static void onModelBakeEvent(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        try {
            ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)((Block)DoggyBlocks.DOG_BED.get()));
            ResourceLocation unbakedModelLoc = new ResourceLocation(resourceLocation.m_135827_(), "block/" + resourceLocation.m_135815_());
            BlockModel model = (BlockModel)event.getModelLoader().m_119341_(unbakedModelLoc);
            DogBedModel customModel = new DogBedModel(event.getModelLoader(), model, model.m_111449_((ModelBakery)event.getModelLoader(), model, ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X180_Y180, unbakedModelLoc, true));
            ((DogBedBlock)DoggyBlocks.DOG_BED.get()).m_49965_().m_61056_().forEach(state -> modelRegistry.put(BlockModelShaper.m_110895_((BlockState)state), customModel));
            modelRegistry.put(new ModelResourceLocation(resourceLocation, "inventory"), customModel);
        }
        catch (Exception e) {
            DoggyTalents2.LOGGER.warn("Could not get base Dog Bed model. Reverting to default textures...");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onInputEvent(MovementInputUpdateEvent event) {
        if (event.getInput().f_108572_) {
            DogEntity dog;
            Entity entity = event.getPlayer().m_20202_();
            if (event.getPlayer().m_20159_() && entity instanceof DogEntity && (dog = (DogEntity)entity).canJump()) {
                dog.setJumpPower(100);
            }
        }
    }

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            boolean creative = screen instanceof CreativeModeInventoryScreen;
            Minecraft mc = Minecraft.m_91087_();
            int width = mc.m_91268_().m_85445_();
            int height = mc.m_91268_().m_85446_();
            int sizeX = creative ? 195 : 176;
            int sizeY = creative ? 136 : 166;
            int guiLeft = (width - sizeX) / 2;
            int guiTop = (height - sizeY) / 2;
            int x = guiLeft + (creative ? 36 : sizeX / 2 - 10);
            int y = guiTop + (creative ? 7 : 48);
            event.addListener((GuiEventListener)new DogInventoryButton(x, y, screen, btn -> {
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new OpenDogScreenData());
                btn.f_93623_ = false;
            }));
        }
    }

    @SubscribeEvent
    public void onScreenDrawForeground(ScreenEvent.DrawScreenEvent event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            boolean creative = screen instanceof CreativeModeInventoryScreen;
            DogInventoryButton btn = null;
            for (Widget widget : screen.f_169369_) {
                if (!(widget instanceof DogInventoryButton)) continue;
                btn = (DogInventoryButton)widget;
                break;
            }
            if (btn.f_93624_ && btn.m_198029_()) {
                RecipeBookComponent recipeBook;
                Minecraft mc = Minecraft.m_91087_();
                int width = mc.m_91268_().m_85445_();
                int height = mc.m_91268_().m_85446_();
                int sizeX = creative ? 195 : 176;
                int sizeY = creative ? 136 : 166;
                int guiLeft = (width - sizeX) / 2;
                int guiTop = (height - sizeY) / 2;
                if (!creative && (recipeBook = ((InventoryScreen)screen).m_5564_()).m_100385_()) {
                    guiLeft += 76;
                }
                btn.m_7428_(event.getPoseStack(), event.getMouseX(), event.getMouseY());
            }
        }
    }

    public void drawSelectionBox(PoseStack matrixStackIn, Player player, float particleTicks, AABB boundingBox) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
        RenderSystem.m_69832_((float)2.0f);
        RenderSystem.m_69472_();
        Vec3 vec3d = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double d0 = vec3d.m_7096_();
        double d1 = vec3d.m_7098_();
        double d2 = vec3d.m_7094_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        LevelRenderer.m_109646_((PoseStack)matrixStackIn, (VertexConsumer)bufferbuilder, (AABB)boundingBox.m_82386_(-d0, -d1, -d2), (float)1.0f, (float)1.0f, (float)0.0f, (float)0.8f);
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

