/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.addon;

import com.google.common.collect.Lists;
import doggytalents.DoggyTalents2;
import doggytalents.common.addon.Addon;
import doggytalents.common.addon.autumnity.AutumnityAddon;
import doggytalents.common.addon.biomesoplenty.BiomesOPlentyAddon;
import doggytalents.common.addon.botania.BotaniaAddon;
import doggytalents.common.addon.itemphysic.ItemPhysicsAddon;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class AddonManager {
    private static final List<Addon> ADDONS = Collections.unmodifiableList(Lists.newArrayList((Object[])new Addon[]{new ItemPhysicsAddon(), new BiomesOPlentyAddon(), new BotaniaAddon(), new AutumnityAddon()}));
    private static final List<Addon> RUN = Lists.newArrayList(ADDONS);

    public static void init() {
        AddonManager.doWork(ADDONS, addon -> true, (MessagePassingQueue.Consumer<Addon>)((MessagePassingQueue.Consumer)Addon::init), (addon, e) -> RUN.remove(addon));
    }

    public static void exec() {
        AddonManager.doWork(RUN, Addon::shouldLoad, (MessagePassingQueue.Consumer<Addon>)((MessagePassingQueue.Consumer)Addon::exec), (addon, e) -> {
            DoggyTalents2.LOGGER.warn("Failed to init {}", (Object)addon.getName());
            e.printStackTrace();
        });
    }

    private static void doWork(List<Addon> addons, Predicate<Addon> shouldRun, MessagePassingQueue.Consumer<Addon> action, BiConsumer<Addon, RuntimeException> failedCallback) {
        for (Addon addon : addons) {
            if (!shouldRun.test(addon)) continue;
            try {
                action.accept((Object)addon);
            }
            catch (RuntimeException e) {
                failedCallback.accept(addon, e);
            }
        }
    }
}

