/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.CompositeWidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainerBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;

public abstract class FilterLogicControlBase<F extends FilterLogicBase, S extends Slot, C extends FilterLogicContainerBase<F, S>>
extends CompositeWidgetBase<WidgetBase> {
    public static final int TAG_FONT_COLOR = 0xF9FFFE;
    public static final int MORE_TAGS_FONT_COLOR = 0xD3D3D3;
    private static final int MAX_TAG_NAME_WIDTH = 68;
    protected final MatchButton[] showMatchButtons;
    protected final int slotsTopYOffset;
    protected final int slotsPerRow;
    protected final int slotsInExtraRow;
    protected final int fullSlotRows;
    private final int totalSlotRows;
    private final StorageScreenBase<?> screen;
    protected final C container;
    private final List<Component> addTagTooltip = new ArrayList<Component>();
    private final List<Component> removeTagTooltip = new ArrayList<Component>();
    private final List<Component> tagListTooltip = new ArrayList<Component>();
    @Nullable
    private ToggleButton<Boolean> nbtButton = null;
    @Nullable
    private ToggleButton<Boolean> durabilityButton = null;
    private int tagButtonsYOffset;

    protected FilterLogicControlBase(StorageScreenBase<?> screen, C container, Position position, boolean buttonsVisible, int slotsPerRow, MatchButton ... showMatchButtons) {
        super(position, new Dimension(0, 0));
        this.screen = screen;
        this.container = container;
        this.slotsTopYOffset = buttonsVisible ? 21 : 0;
        this.slotsPerRow = slotsPerRow;
        this.showMatchButtons = showMatchButtons;
        this.fullSlotRows = ((FilterLogicContainerBase)container).getFilterSlots().size() / slotsPerRow;
        this.slotsInExtraRow = ((FilterLogicContainerBase)container).getFilterSlots().size() % slotsPerRow;
        this.totalSlotRows = this.fullSlotRows + (this.slotsInExtraRow > 0 ? 1 : 0);
        if (this.shouldShow(MatchButton.ALLOW_LIST)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x, this.y), ButtonDefinitions.ALLOW_LIST, button -> container.setAllowList(!container.isAllowList()), () -> container.isAllowList()));
        }
        if (this.shouldShow(MatchButton.PRIMARY_MATCH)) {
            this.addChild(new ToggleButton<PrimaryMatch>(new Position(this.x + 18, this.y), ButtonDefinitions.PRIMARY_MATCH, button -> {
                PrimaryMatch next = container.getPrimaryMatch().next();
                if (next == PrimaryMatch.TAGS) {
                    container.getFilterSlots().forEach(slot -> {
                        slot.f_40220_ = -1000;
                    });
                    this.onTagsMatchSelected();
                }
                container.setPrimaryMatch(next);
                this.setDurabilityAndNbtButtonsVisibility();
                this.moveSlotsToView();
            }, () -> container.getPrimaryMatch()));
            this.addTagButtons();
        }
        if (this.shouldShow(MatchButton.DURABILITY)) {
            this.durabilityButton = new ToggleButton<Boolean>(new Position(this.x + 36, this.y), ButtonDefinitions.MATCH_DURABILITY, button -> container.setMatchDurability(!container.shouldMatchDurability()), () -> container.shouldMatchDurability());
            this.addChild(this.durabilityButton);
        }
        if (this.shouldShow(MatchButton.NBT)) {
            this.nbtButton = new ToggleButton<Boolean>(new Position(this.x + 54, this.y), ButtonDefinitions.MATCH_NBT, button -> container.setMatchNbt(!container.shouldMatchNbt()), () -> container.shouldMatchNbt());
            this.addChild(this.nbtButton);
        }
        this.updateDimensions(Math.max(slotsPerRow * 18, this.getMaxButtonWidth()), (this.fullSlotRows + (this.slotsInExtraRow > 0 ? 1 : 0)) * 18 + this.slotsTopYOffset);
        this.setDurabilityAndNbtButtonsVisibility();
    }

    private void setDurabilityAndNbtButtonsVisibility() {
        boolean visible;
        boolean bl = visible = ((FilterLogicContainerBase)this.container).getPrimaryMatch() != PrimaryMatch.TAGS;
        if (this.nbtButton != null) {
            this.nbtButton.setVisible(visible);
        }
        if (this.durabilityButton != null) {
            this.durabilityButton.setVisible(visible);
        }
    }

    protected void onTagsMatchSelected() {
    }

    private void addTagButtons() {
        this.tagButtonsYOffset = this.slotsTopYOffset + this.getTagListHeight();
        this.addChild(new TagButton(new Position(this.x + 36, this.y + this.tagButtonsYOffset), ButtonDefinitions.REMOVE_TAG, button -> {
            ((FilterLogicContainerBase)this.container).removeSelectedTag();
            this.updateTagListAndRemoveTooltips();
            this.updateAddTooltip();
        }, delta -> {
            if (delta < 0.0) {
                ((FilterLogicContainerBase)this.container).selectNextTagToRemove();
            } else {
                ((FilterLogicContainerBase)this.container).selectPreviousTagToRemove();
            }
            this.updateTagListAndRemoveTooltips();
        }){

            @Override
            protected List<Component> getTooltip() {
                return FilterLogicControlBase.this.removeTagTooltip;
            }
        });
        this.updateTagListAndRemoveTooltips();
        this.addChild(new TagButton(new Position(this.x + 18, this.y + this.tagButtonsYOffset), ButtonDefinitions.ADD_TAG, button -> {
            ((FilterLogicContainerBase)this.container).addSelectedTag();
            this.updateAddTooltip();
            this.updateTagListAndRemoveTooltips();
        }, delta -> {
            if (delta < 0.0) {
                ((FilterLogicContainerBase)this.container).selectNextTagToAdd();
            } else {
                ((FilterLogicContainerBase)this.container).selectPreviousTagToAdd();
            }
            this.updateAddTooltip();
        }){

            @Override
            protected List<Component> getTooltip() {
                return FilterLogicControlBase.this.addTagTooltip;
            }
        });
        this.updateAddTooltip();
        ((FilterLogicContainerBase)this.container).getTagSelectionSlot().setOnUpdate(this::updateAddTooltip);
        this.addChild(new ToggleButton<Boolean>(new Position(this.x + 54, this.y + this.tagButtonsYOffset), ButtonDefinitions.MATCH_ANY_TAG, button -> ((FilterLogicContainerBase)this.container).setMatchAnyTag(!((FilterLogicContainerBase)this.container).shouldMatchAnyTag()), () -> this.container.shouldMatchAnyTag()){

            @Override
            protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
                if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                    super.renderBg(matrixStack, minecraft, mouseX, mouseY);
                }
            }

            @Override
            protected void renderWidget(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                    super.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
                }
            }

            @Override
            public boolean m_5953_(double mouseX, double mouseY) {
                return ((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS && super.m_5953_(mouseX, mouseY);
            }
        });
    }

    private void updateTagListAndRemoveTooltips() {
        this.updateTagListTooltip();
        this.updateRemoveTooltip();
    }

    private void updateTagListTooltip() {
        this.tagListTooltip.clear();
        this.tagListTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeKey("tag_list.title")).m_130944_(new ChatFormatting[0]));
        Set<TagKey<Item>> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
        if (tagNames.isEmpty()) {
            this.tagListTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeKey("tag_list.empty")).m_130940_(ChatFormatting.DARK_GRAY));
            return;
        }
        for (TagKey<Item> tagName : tagNames) {
            this.tagListTooltip.add((Component)new TextComponent("> " + tagName.f_203868_()).m_130940_(ChatFormatting.GRAY));
        }
    }

    private void updateRemoveTooltip() {
        this.removeTagTooltip.clear();
        this.removeTagTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeButton("remove_tag")));
        Set<TagKey<Item>> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
        if (tagNames.isEmpty()) {
            this.removeTagTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeButton("remove_tag.empty")).m_130940_(ChatFormatting.RED));
            return;
        }
        int curIndex = 0;
        for (TagKey<Item> tagName : tagNames) {
            if (curIndex == ((FilterLogicContainerBase)this.container).getSelectedTagToRemove()) {
                this.removeTagTooltip.add((Component)new TextComponent("-> " + tagName.f_203868_()).m_130940_(ChatFormatting.RED));
            } else {
                this.removeTagTooltip.add((Component)new TextComponent("> " + tagName.f_203868_()).m_130940_(ChatFormatting.GRAY));
            }
            ++curIndex;
        }
        this.removeTagTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeButton("remove_tag.controls")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
    }

    private void updateAddTooltip() {
        this.addTagTooltip.clear();
        this.addTagTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeButton("add_tag")));
        if (((FilterLogicContainerBase)this.container).getTagSelectionSlot().m_7993_().m_41619_()) {
            this.addTagTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeButton("add_tag.no_item")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
            return;
        }
        Set<TagKey<Item>> tagsToAdd = ((FilterLogicContainerBase)this.container).getTagsToAdd();
        int curIndex = 0;
        for (TagKey<Item> tagName : tagsToAdd) {
            if (curIndex == ((FilterLogicContainerBase)this.container).getSelectedTagToAdd()) {
                this.addTagTooltip.add((Component)new TextComponent("-> " + tagName.f_203868_()).m_130940_(ChatFormatting.GREEN));
            } else {
                this.addTagTooltip.add((Component)new TextComponent("> " + tagName.f_203868_()).m_130940_(ChatFormatting.GRAY));
            }
            ++curIndex;
        }
        if (tagsToAdd.isEmpty()) {
            this.addTagTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeButton("add_tag.no_additional_tags")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW}));
        } else {
            this.addTagTooltip.add((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeButton("add_tag.controls")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
        }
    }

    protected int getMaxButtonWidth() {
        int maxWidth = 0;
        for (WidgetBase w : this.children) {
            int buttonWidth = w.getX() + w.getWidth() - this.x;
            if (buttonWidth <= maxWidth) continue;
            maxWidth = buttonWidth;
        }
        return maxWidth;
    }

    protected boolean shouldShow(MatchButton matchButton) {
        for (MatchButton showMatchButton : this.showMatchButtons) {
            if (showMatchButton != matchButton) continue;
            return true;
        }
        return false;
    }

    public void moveSlotsToView() {
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
            FilterLogicContainerBase.TagSelectionSlot slot = ((FilterLogicContainerBase)this.container).getTagSelectionSlot();
            slot.f_40220_ = this.x - this.screen.getGuiLeft() + 1;
            slot.f_40221_ = this.y - this.screen.getGuiTop() + this.tagButtonsYOffset + 1;
            ((FilterLogicContainerBase)this.container).getFilterSlots().forEach(s -> {
                s.f_40220_ = -1000;
            });
        } else {
            int upgradeSlotNumber = 0;
            for (Slot slot : ((FilterLogicContainerBase)this.container).getFilterSlots()) {
                slot.f_40220_ = this.x - this.screen.getGuiLeft() + 1 + upgradeSlotNumber % this.slotsPerRow * 18;
                slot.f_40221_ = this.y - this.screen.getGuiTop() + this.slotsTopYOffset + 1 + upgradeSlotNumber / this.slotsPerRow * 18;
                ++upgradeSlotNumber;
            }
            ((FilterLogicContainerBase)this.container).getTagSelectionSlot().f_40220_ = -1000;
        }
    }

    @Override
    protected void renderWidget(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
            this.renderTagNames(matrixStack);
        }
    }

    private void renderTagNames(PoseStack matrixStack) {
        int count = 0;
        int prefixWidth = this.font.m_92895_("...");
        Set<TagKey<Item>> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
        int maxTagNameLines = this.getTagListHeight() / 10;
        for (TagKey<Item> tagName : tagNames) {
            if (tagNames.size() > maxTagNameLines && count == maxTagNameLines - 1) {
                this.font.m_92889_(matrixStack, (Component)new TranslatableComponent(TranslationHelper.INSTANCE.translUpgradeKey("tag_list.tag_overflow"), new Object[]{String.valueOf(tagNames.size() - (maxTagNameLines - 1))}), (float)this.x + 2.0f, (float)this.y + 23.0f + (float)(count * 10), 0xD3D3D3);
                break;
            }
            String name = tagName.f_203868_().toString();
            Object shortened = name;
            if (this.font.m_92895_(name) > 68 && !((String)(shortened = this.font.m_92837_(name, 68 - prefixWidth, true))).equals(name)) {
                shortened = "..." + (String)shortened;
            }
            this.font.m_92883_(matrixStack, (String)shortened, (float)this.x + 2.0f, (float)this.y + 23.0f + (float)(count * 10), 0xF9FFFE);
            ++count;
        }
    }

    @Override
    public void renderTooltip(Screen screen, PoseStack poseStack, int mouseX, int mouseY) {
        super.renderTooltip(screen, poseStack, mouseX, mouseY);
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() == PrimaryMatch.TAGS && this.isMouseOverTagList(mouseX, mouseY)) {
            screen.m_169388_(poseStack, this.tagListTooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private int getTagListHeight() {
        return (this.totalSlotRows - 1) * 18;
    }

    private boolean isMouseOverTagList(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.getTagListWidth()) && mouseY >= (double)(this.y + this.slotsTopYOffset) && mouseY < (double)(this.y + this.slotsTopYOffset + this.getTagListHeight());
    }

    @Override
    protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() != PrimaryMatch.TAGS) {
            GuiHelper.renderSlotsBackground(matrixStack, this.x, this.y + this.slotsTopYOffset, this.slotsPerRow, this.fullSlotRows, this.slotsInExtraRow);
        } else {
            GuiHelper.renderSlotsBackground(matrixStack, this.x, this.y + this.tagButtonsYOffset, 1, 1, 0);
            GuiHelper.renderControlBackground(matrixStack, this.x, this.y + this.slotsTopYOffset, this.getTagListWidth(), this.getTagListHeight());
        }
    }

    private int getTagListWidth() {
        return this.slotsPerRow * 18;
    }

    public static enum MatchButton {
        ALLOW_LIST,
        PRIMARY_MATCH,
        DURABILITY,
        NBT;

    }

    private class TagButton
    extends Button {
        private final DoubleConsumer onScroll;

        public TagButton(Position position, ButtonDefinition buttonDefinition, IntConsumer onClick, DoubleConsumer onScroll) {
            super(position, buttonDefinition, onClick);
            this.onScroll = onScroll;
        }

        @Override
        protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                super.renderBg(matrixStack, minecraft, mouseX, mouseY);
            }
        }

        @Override
        protected void renderWidget(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                super.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return ((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS && super.m_5953_(mouseX, mouseY);
        }

        public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() != PrimaryMatch.TAGS) {
                return false;
            }
            this.onScroll.accept(pDelta);
            return true;
        }
    }
}

