/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathcompass.handler;

import fuzs.deathcompass.DeathCompass;
import fuzs.deathcompass.capability.DeathTrackerCapability;
import fuzs.deathcompass.config.ServerConfig;
import fuzs.deathcompass.registry.ModRegistry;
import fuzs.deathcompass.world.item.DeathCompassItem;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DeathCompassHandler {
    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent evt) {
        ServerPlayer player;
        LazyOptional optional;
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity instanceof ServerPlayer && (optional = (player = (ServerPlayer)livingEntity).getCapability(ModRegistry.DEATH_TRACKER_CAPABILITY)).isPresent()) {
            if (!evt.getDrops().isEmpty() || !((ServerConfig)DeathCompass.CONFIG.server()).onlyOnItemsLost) {
                DeathTrackerCapability.saveLastDeathData((DeathTrackerCapability)optional.orElseThrow(IllegalStateException::new), player.m_142538_(), (ResourceKey<Level>)player.f_19853_.m_46472_());
            } else {
                DeathTrackerCapability.clearLastDeathData((DeathTrackerCapability)optional.orElseThrow(IllegalStateException::new));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        if (!evt.isWasDeath()) {
            return;
        }
        Player player = evt.getOriginal();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.reviveCaps();
            if (player2.getCapability(ModRegistry.DEATH_TRACKER_CAPABILITY).map(DeathTrackerCapability::hasLastDeathData).orElse(false).booleanValue()) {
                ServerLevel world = player2.m_183503_();
                if (!(!((ServerConfig)DeathCompass.CONFIG.server()).ignoreKeepInventory && world.m_46469_().m_46207_(GameRules.f_46133_) || ((ServerConfig)DeathCompass.CONFIG.server()).survivalPlayersOnly && (player2.m_7500_() || player2.m_5833_()))) {
                    Optional<ItemStack> deathCompass = DeathCompassItem.createDeathCompass((Player)player2);
                    deathCompass.ifPresent(itemStack -> evt.getPlayer().m_150109_().m_36054_(itemStack));
                }
            }
            player2.invalidateCaps();
        }
    }
}

