/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.api.util.client.TriangleDirection;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedSlopedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction orientation;

    public FramedSlopedPrismModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.isStateInvalid()) {
            quadMap.get(quad.m_111306_()).add(quad);
            return;
        }
        Direction quadFace = quad.m_111306_();
        if (quadFace == this.orientation.m_122424_() && !Utils.isY(this.orientation)) {
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (Utils.isY(this.facing)) {
                TriangleDirection triDir;
                TriangleDirection triangleDirection = triDir = this.facing == Direction.UP ? TriangleDirection.UP : TriangleDirection.DOWN;
                if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(triangle, this.facing == Direction.UP);
                    quadMap.get(null).add(triangle);
                }
            } else {
                TriangleDirection triDir;
                TriangleDirection triangleDirection = triDir = this.orientation == this.facing.m_122428_() ? TriangleDirection.RIGHT : TriangleDirection.LEFT;
                if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                    BakedQuadTransformer.createSideSlopeQuad(triangle, triDir == TriangleDirection.RIGHT);
                    quadMap.get(null).add(triangle);
                }
            }
        } else if (quadFace == this.facing && Utils.isY(this.orientation)) {
            TriangleDirection triDir = this.orientation == Direction.UP ? TriangleDirection.UP : TriangleDirection.DOWN;
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                BakedQuadTransformer.createTopBottomSlopeQuad(triangle, this.orientation == Direction.DOWN);
                quadMap.get(null).add(triangle);
            }
        } else if (quadFace == this.orientation) {
            TriangleDirection triDir;
            if (Utils.isY(this.facing)) {
                triDir = this.facing == Direction.UP ? TriangleDirection.UP : TriangleDirection.DOWN;
            } else if (!Utils.isY(this.orientation)) {
                triDir = quadFace == this.facing.m_122427_() ? TriangleDirection.RIGHT : TriangleDirection.LEFT;
            } else {
                BakedQuad triangle = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomSmallTriangleQuad(triangle, this.facing)) {
                    quadMap.get(quadFace).add(triangle);
                }
                return;
            }
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                quadMap.get(quadFace).add(triangle);
            }
        } else if (Utils.isY(this.facing) && quadFace.m_122434_() != this.facing.m_122434_() && quadFace.m_122434_() != this.orientation.m_122434_()) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slope, this.facing == Direction.DOWN, 0.5f)) {
                BakedQuad corner = ModelUtils.duplicateQuad(slope);
                if (BakedQuadTransformer.createVerticalSideQuad(corner, this.orientation, 0.5f) && BakedQuadTransformer.createSideTriangleQuad(corner, quadFace == this.orientation.m_122427_(), this.facing == Direction.DOWN)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(corner, this.facing == Direction.UP);
                    quadMap.get(null).add(corner);
                }
                if (BakedQuadTransformer.createVerticalSideQuad(slope, this.orientation.m_122424_(), 0.5f)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(slope, this.facing == Direction.UP);
                    quadMap.get(null).add(slope);
                }
            }
        } else if (Utils.isY(this.orientation) && quadFace.m_122434_() != this.facing.m_122434_() && quadFace.m_122434_() != this.orientation.m_122434_()) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(slope, this.facing, 0.5f)) {
                BakedQuad corner = ModelUtils.duplicateQuad(slope);
                if (BakedQuadTransformer.createHorizontalSideQuad(corner, this.orientation == Direction.DOWN, 0.5f) && BakedQuadTransformer.createSideTriangleQuad(corner, quadFace == this.facing.m_122428_(), this.orientation == Direction.UP)) {
                    BakedQuadTransformer.createSideSlopeQuad(corner, quadFace == this.facing.m_122427_());
                    quadMap.get(null).add(corner);
                }
                if (BakedQuadTransformer.createHorizontalSideQuad(slope, this.orientation == Direction.UP, 0.5f)) {
                    BakedQuadTransformer.createSideSlopeQuad(slope, quadFace == this.facing.m_122427_());
                    quadMap.get(null).add(slope);
                }
            }
        } else if (!Utils.isY(this.orientation) && !Utils.isY(this.facing) && quadFace == this.facing) {
            BakedQuad corner;
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slope, false, 0.5f)) {
                corner = ModelUtils.duplicateQuad(slope);
                if (BakedQuadTransformer.createVerticalSideQuad(corner, this.orientation, 0.5f) && BakedQuadTransformer.createSideTriangleQuad(corner, this.orientation == this.facing.m_122428_(), false)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(corner, false);
                    quadMap.get(null).add(corner);
                }
                if (BakedQuadTransformer.createVerticalSideQuad(slope, this.orientation.m_122424_(), 0.5f)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(slope, false);
                    quadMap.get(null).add(slope);
                }
            }
            if (BakedQuadTransformer.createHorizontalSideQuad(slope = ModelUtils.duplicateQuad(quad), true, 0.5f)) {
                corner = ModelUtils.duplicateQuad(slope);
                if (BakedQuadTransformer.createVerticalSideQuad(corner, this.orientation, 0.5f) && BakedQuadTransformer.createSideTriangleQuad(corner, this.orientation == this.facing.m_122428_(), true)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(corner, true);
                    quadMap.get(null).add(corner);
                }
                if (BakedQuadTransformer.createVerticalSideQuad(slope, this.orientation.m_122424_(), 0.5f)) {
                    BakedQuadTransformer.createTopBottomSlopeQuad(slope, true);
                    quadMap.get(null).add(slope);
                }
            }
        }
    }

    private boolean isStateInvalid() {
        return this.orientation.m_122434_() == this.facing.m_122434_();
    }

    public static BlockState itemSource() {
        return (BlockState)((BlockState)((Block)FBContent.blockFramedSlopedPrism.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)PropertyHolder.ORIENTATION, (Comparable)Direction.WEST);
    }
}

