/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedPrismBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> side == ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
    public static final SideSkipPredicate SKIP_PREDICATE = (level, pos, state, adjState, side) -> {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        if (side.m_122434_() != axis) {
            return false;
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedPrism.get())) {
            Direction adjFacing = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction.Axis adjAxis = (Direction.Axis)adjState.m_61143_((Property)BlockStateProperties.f_61365_);
            return adjFacing == facing && adjAxis == axis && SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjState.m_60713_((Block)FBContent.blockFramedSlopedPrism.get())) {
            Direction adjFacing = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction adjOrientation = (Direction)adjState.m_61143_((Property)PropertyHolder.ORIENTATION);
            return adjFacing == facing && adjOrientation == side.m_122424_() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    };

    public FramedPrismBlock() {
        super(BlockType.FRAMED_PRISM);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, BlockStateProperties.f_61365_, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction.Axis axis;
        BlockState state = this.m_49966_();
        Direction face = context.m_43719_();
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
        if (Utils.isY(face)) {
            axis = context.m_8125_().m_122434_();
        } else {
            Vec3 subHit = Utils.fraction(context.m_43720_());
            double xz = (Utils.isX(face) ? subHit.m_7094_() : subHit.m_7096_()) - 0.5;
            double y = subHit.m_7098_() - 0.5;
            axis = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? face.m_122427_().m_122434_() : Direction.Axis.Y;
        }
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
        return FramedPrismBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)16.0), FramedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0)}).m_83296_();
        VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.5, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0)}).m_83296_();
        VoxelShape shapeXZ = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)12.0, (double)16.0, (double)15.5, (double)16.0), FramedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0)}).m_83296_();
        VoxelShape shapeY = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0)}).m_83296_();
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            if (axis == facing.m_122434_()) {
                builder.put((Object)state, (Object)Shapes.m_83144_());
                continue;
            }
            if (Utils.isY(facing)) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, axis == Direction.Axis.Y ? shapeY : shapeXZ));
        }
        return builder.build();
    }
}

