/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.menu;

import com.google.common.base.Preconditions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedChestBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedStorageBlockEntity;

public class FramedStorageMenu
extends AbstractContainerMenu {
    private static final int MAX_SLOT_CHEST = 27;
    private final FramedStorageBlockEntity blockEntity;

    public FramedStorageMenu(int windowId, Inventory inv, BlockEntity blockEntity) {
        super((MenuType)FBContent.menuTypeFramedStorage.get(), windowId);
        Preconditions.checkArgument((boolean)(blockEntity instanceof FramedStorageBlockEntity));
        this.blockEntity = (FramedStorageBlockEntity)blockEntity;
        this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 9; ++col) {
                    this.m_38897_((Slot)new SlotItemHandler(handler, col + row * 9, 8 + col * 18, 18 + row * 18));
                }
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 85 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 143));
        }
    }

    public FramedStorageMenu(int windowId, Inventory inv, FriendlyByteBuf extraData) {
        this(windowId, inv, inv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.isUsableByPlayer(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack remainder = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            remainder = stack.m_41777_();
            if (index < 27 ? !this.m_38903_(stack, 27, this.f_38839_.size(), true) : !this.m_38903_(stack, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return remainder;
    }

    public void m_6877_(Player player) {
        FramedStorageBlockEntity framedStorageBlockEntity;
        super.m_6877_(player);
        if (!this.blockEntity.m_58904_().m_5776_() && (framedStorageBlockEntity = this.blockEntity) instanceof FramedChestBlockEntity) {
            FramedChestBlockEntity chest = (FramedChestBlockEntity)framedStorageBlockEntity;
            chest.close();
        }
    }
}

