/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.inventory.InventoryShifted;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.tileentity.TileEntityPlatFormer;

public class InventoryPlatFormer
extends InventoryInternal {
    private final TileEntityPlatFormer platFormer;

    public InventoryPlatFormer(TileEntityPlatFormer invOwner) {
        super((BlockEntity)invOwner, "internal", 15, "inv.platformer");
        this.platFormer = invOwner;
    }

    @Nonnull
    public ItemStack m_7407_(int slotId, int amount) {
        if (slotId == 3) {
            if (this.contents[4].m_41619_() && this.platFormer.canCraft()) {
                this.platFormer.doCraft();
                ItemStack stack = this.platFormer.getOutputItem();
                if (!stack.m_41619_() && stack.m_41613_() <= amount) {
                    this.m_6596_();
                    return stack;
                }
                this.contents[4] = stack;
                return this.m_7407_(4, amount);
            }
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.m_8020_(slotId);
        if (!stack.m_41619_()) {
            if (stack.m_41613_() <= amount) {
                this.contents[slotId] = ItemStack.f_41583_;
                this.m_6596_();
                return stack;
            }
            stack = stack.m_41620_(amount);
            if (this.contents[slotId].m_41619_()) {
                this.contents[slotId] = ItemStack.f_41583_;
            }
            this.m_6596_();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_7013_(int slotId, ItemStack stack) {
        return slotId > 4;
    }

    public InvWrapper getWrapperBasic() {
        return new WrapperBasic((Container)new InventoryBasic((Container)this));
    }

    public InvWrapper getWrapperOutput() {
        return new WrapperOutput((Container)new InventoryOutput((Container)this));
    }

    public InvWrapper getWrapperDeconstruct() {
        return new WrapperDeconstruct((Container)new InventoryDeconstruct((Container)this));
    }

    public InvWrapper getWrapperStorage() {
        return new InvWrapper((Container)new InventoryStorage((Container)this));
    }

    private class WrapperBasic
    extends InvWrapper {
        private WrapperBasic(Container inv) {
            super(inv);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot > 1 ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot > 1) {
                return ItemStack.f_41583_;
            }
            if (slot == 0 && this.getInv().m_8020_(1).m_41619_()) {
                return InventoryPlatFormer.this.platFormer.canCraft() ? super.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }

    private static class InventoryBasic
    extends InventoryShifted {
        private InventoryBasic(Container parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId < 2 ? slotId + 3 : slotId + 4;
        }

        public int m_6643_() {
            return this.parent.m_6643_() - 4;
        }

        public Component m_7755_() {
            return new TextComponent("inv.platformer");
        }
    }

    private class WrapperOutput
    extends WrapperBasic {
        private WrapperOutput(Container inv) {
            super(inv);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }
    }

    private static class InventoryOutput
    extends InventoryShifted {
        private InventoryOutput(Container parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId + 3;
        }

        public int m_6643_() {
            return 2;
        }

        public Component m_7755_() {
            return new TextComponent("inv.platformer.output");
        }
    }

    private static class WrapperDeconstruct
    extends InvWrapper {
        private WrapperDeconstruct(Container inv) {
            super(inv);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return !stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform ? super.insertItem(slot, stack, simulate) : stack;
        }
    }

    private static class InventoryDeconstruct
    extends InventoryShifted {
        private InventoryDeconstruct(Container parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return 5;
        }

        public int m_6643_() {
            return 1;
        }

        public Component m_7755_() {
            return new TextComponent("inv.platformer.deconstruct");
        }
    }

    private static class InventoryStorage
    extends InventoryShifted {
        private InventoryStorage(Container parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId + 6;
        }

        public int m_6643_() {
            return 9;
        }

        public Component m_7755_() {
            return new TextComponent("inv.platformer.storage");
        }
    }
}

