/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.common.ToolHelper;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.gui.GuiPlatformSelect;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class EventHandler {
    private static long debounce;

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity te;
        Player player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (player == null || stack.m_41619_()) {
            return;
        }
        Level world = event.getWorld();
        BlockState state = world.m_8055_(event.getPos());
        if (state.m_60734_() instanceof BlockPlatformBase && (te = world.m_7702_(event.getPos())) instanceof TileEntityPlatformBase) {
            TileEntityPlatformBase tile = (TileEntityPlatformBase)te;
            if (player.m_6047_() && (Integer)state.m_61143_((Property)BlockPlatformBase.LEVEL) == 0 && stack.m_41720_() instanceof BlockItem && ((Boolean)Configuration.DUST_COVERING.canManuallyAdd.get()).booleanValue() && tile.setLevelTexture(stack)) {
                Function.setBlock((LevelAccessor)world, (BlockPos)event.getPos(), (BlockState)((BlockState)state.m_61124_((Property)BlockPlatformBase.LEVEL, (Comparable)Integer.valueOf(3))), (boolean)true);
                tile.playLevelTextureSound(player, true);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
            if (ToolHelper.isWrench((ItemStack)stack) && state.m_60734_() instanceof BlockPlatformBase) {
                boolean changeType;
                EnumPlatformType platformType = ((BlockPlatformBase)state.m_60734_()).getPlatformType();
                boolean bl = changeType = platformType != EnumPlatformType.FRAME && player.m_6047_();
                if (changeType && this.useGUI(player, platformType)) {
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openGUISelect(player, world, event.getPos(), platformType, tile));
                } else {
                    BlockState result = ((BlockPlatformBase)state.m_60734_()).rotateBlock(state, (LevelAccessor)world, event.getPos(), tile, changeType ? Rotation.NONE : Rotation.COUNTERCLOCKWISE_90);
                    player.m_6674_(event.getHand());
                    if (!changeType && result != state) {
                        Function.setBlock((LevelAccessor)world, (BlockPos)event.getPos(), (BlockState)result, (boolean)true);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private boolean useGUI(Player player, EnumPlatformType platformType) {
        int option = player.f_19853_.f_46443_ ? ((Configuration.Menu_General.PlatformSelect)((Object)Configuration.GENERAL.platformSelect.get())).ordinal() : ((Integer)PlayerConfigs.getConfig((Player)player, (ResourceLocation)Values.keyConfigPlatformSelectMode, (Object)Configuration.Menu_General.PlatformSelect.MIXED.ordinal())).intValue();
        return option == Configuration.Menu_General.PlatformSelect.GUI.ordinal() || option == Configuration.Menu_General.PlatformSelect.MIXED.ordinal() && (platformType == EnumPlatformType.FLAT || platformType == EnumPlatformType.FLOOR);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGUISelect(Player player, Level world, BlockPos pos, EnumPlatformType platformType, TileEntityPlatformBase tile) {
        if (System.currentTimeMillis() > debounce + 250L) {
            debounce = System.currentTimeMillis();
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)new GuiPlatformSelect(player, world, pos, platformType, tile)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_ && event.getEntity() instanceof Player) {
            Configuration.sync();
        }
    }
}

