/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.objects.FurnitureObject;
import com.mcwfurnitures.kikoz.storage.ChairEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoubleBlock
extends FurnitureObject {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final EnumProperty<DoubleTallPart> PART = EnumProperty.m_61587_((String)"part", DoubleTallPart.class);
    protected static final VoxelShape BASE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public DoubleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)DoubleTallPart.LOWER)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        return ChairEntity.create(level, pos, 0.4, playerEntity);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        return BASE;
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleTallPart doubleblockhalf = (DoubleTallPart)((Object)state.m_61143_(PART));
        if (doubleblockhalf == DoubleTallPart.UPPER && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60713_(state.m_60734_()) && blockstate.m_61143_(PART) == DoubleTallPart.LOWER) {
            BlockState blockstate1 = blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockpos, blockstate1, 35);
        }
    }

    public void place(Level level, BlockPos pos, Direction direction) {
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)DoubleTallPart.LOWER))).m_61124_((Property)FACING, (Comparable)direction);
        level.m_7731_(pos, state, 3);
        this.place(level, pos, state, direction.m_122424_());
    }

    public void place(Level level, BlockPos pos, BlockState state, Direction direction) {
        FluidState middleFluidState = level.m_6425_(pos.m_7494_());
        level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)DoubleTallPart.UPPER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(middleFluidState.m_76152_() == Fluids.f_76193_)), 3);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            this.place(level, pos, state, entity.m_6350_());
        }
    }

    public void remove(Level level, BlockPos pos, BlockState state) {
        BlockPos FurniturePartPos;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos FurniturePos = this.getFurniturePos(pos, (DoubleTallPart)((Object)state.m_61143_(PART)), facing);
        BlockState FurnitureBlockState = level.m_8055_(FurniturePos);
        if (FurnitureBlockState.m_60734_() == this && !pos.equals((Object)FurniturePos)) {
            this.removePart(level, FurniturePos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = level.m_8055_(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).m_60734_() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(level, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = level.m_8055_(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).m_60734_() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(level, FurniturePartPos, FurnitureBlockState);
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            DoubleBlock.preventCreativeDropFromBottomPart(world, pos, state, player);
        } else {
            this.remove(world, pos, state);
            super.m_5707_(world, pos, state, player);
        }
    }

    private BlockPos getFurnitureMiddlePos(BlockPos base, Direction facing) {
        return base.m_7494_();
    }

    private BlockPos getFurniturePos(BlockPos pos, DoubleTallPart part, Direction facing) {
        if (part == DoubleTallPart.LOWER) {
            return pos;
        }
        return pos.m_7495_();
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76145_() : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleTallPart doubleblockhalf = (DoubleTallPart)((Object)stateIn.m_61143_(PART));
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleTallPart.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(PART) != doubleblockhalf ? (BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleTallPart.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private void removePart(Level world, BlockPos pos, BlockState state) {
        FluidState fluidState = world.m_6425_(pos);
        if (fluidState.m_76152_() == Fluids.f_76193_) {
            world.m_6933_(pos, state, fluidState.m_76186_(), 35);
        } else {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos pos = context.m_8083_();
        BlockPos FurnitureMiddlePos = this.getFurnitureMiddlePos(pos, context.m_8125_().m_122424_());
        if (pos.m_123342_() < 255 && FurnitureMiddlePos.m_123342_() < 255 && context.m_43725_().m_8055_(pos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(PART, (Comparable)((Object)DoubleTallPart.LOWER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() == 8));
        }
        return null;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING, WATERLOGGED});
    }

    public static enum DoubleTallPart implements StringRepresentable
    {
        UPPER("upper"),
        LOWER("lower");

        private final String name;

        private DoubleTallPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

