/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.Index;
import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.blocks.base.ISeat;
import com.mrh0.buildersaddition.entity.SeatEntity;
import com.mrh0.buildersaddition.state.StoolState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Chair
extends BaseDerivativeBlock
implements ISeat {
    private static VoxelShape SHAPE_PILLOW = Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    private static VoxelShape SHAPE_BASE = Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    public static final EnumProperty<StoolState> PILLOW = EnumProperty.m_61587_((String)"pillow", StoolState.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    private VoxelShape getLegShape(int x, int z, boolean tall) {
        return Block.m_49796_((double)x, (double)0.0, (double)z, (double)((double)x + 2.0), (double)(tall ? 16.0 : 6.0), (double)((double)z + 2.0));
    }

    private VoxelShape getBackShape(Direction dir) {
        switch (dir) {
            case NORTH: {
                return Block.m_49796_((double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)18.0, (double)14.0);
            }
            case WEST: {
                return Block.m_49796_((double)12.0, (double)12.0, (double)4.0, (double)14.0, (double)18.0, (double)12.0);
            }
            case EAST: {
                return Block.m_49796_((double)2.0, (double)12.0, (double)4.0, (double)4.0, (double)18.0, (double)12.0);
            }
        }
        return Block.m_49796_((double)4.0, (double)12.0, (double)2.0, (double)12.0, (double)18.0, (double)4.0);
    }

    private VoxelShape getLegsShape(Direction dir) {
        switch (dir) {
            case NORTH: {
                return Shapes.m_83124_((VoxelShape)this.getLegShape(2, 2, false), (VoxelShape[])new VoxelShape[]{this.getLegShape(12, 2, false), this.getLegShape(2, 12, true), this.getLegShape(12, 12, true)});
            }
            case WEST: {
                return Shapes.m_83124_((VoxelShape)this.getLegShape(2, 2, false), (VoxelShape[])new VoxelShape[]{this.getLegShape(12, 2, true), this.getLegShape(2, 12, false), this.getLegShape(12, 12, true)});
            }
            case EAST: {
                return Shapes.m_83124_((VoxelShape)this.getLegShape(2, 2, true), (VoxelShape[])new VoxelShape[]{this.getLegShape(12, 2, false), this.getLegShape(2, 12, true), this.getLegShape(12, 12, false)});
            }
        }
        return Shapes.m_83124_((VoxelShape)this.getLegShape(2, 2, true), (VoxelShape[])new VoxelShape[]{this.getLegShape(12, 2, true), this.getLegShape(2, 12, false), this.getLegShape(12, 12, false)});
    }

    public Chair(String name, Block source) {
        super(name, source);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PILLOW, (Comparable)((Object)StoolState.None)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PILLOW});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(c.m_7078_() ? c.m_8125_() : c.m_8125_().m_122424_()));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean type;
        boolean bl = type = state.m_61143_(PILLOW) == StoolState.None;
        if (type) {
            Item item = player.m_21120_(hand).m_41720_();
            for (int i = 0; i < Index.PILLOW.length; ++i) {
                if (item != Index.PILLOW[i].m_5456_()) continue;
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                world.m_46597_(pos, (BlockState)state.m_61124_(PILLOW, (Comparable)((Object)StoolState.fromIndex(i))));
                world.m_5594_(player, pos, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
        }
        return SeatEntity.createSeat(world, pos, (LivingEntity)player, type ? 0.3875 : 0.45, type ? SoundEvents.f_12634_ : SoundEvents.f_12641_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (state.m_61143_(PILLOW) == StoolState.None) {
            return Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{this.getBackShape(dir), this.getLegsShape(dir)});
        }
        return Shapes.m_83124_((VoxelShape)SHAPE_PILLOW, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, this.getBackShape(dir), this.getLegsShape(dir)});
    }
}

