/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.machines.client.gui.widget.AbstractCMGuiWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class ScrollableWrappedTextWidget
extends AbstractCMGuiWidget {
    private final String localeKey;
    private double yScroll = 0.0;
    private final Font fontRenderer;
    private int maxLinesToShow;
    private int lineIndexStart;
    private List<FormattedCharSequence> lines;
    private int charSize;

    public ScrollableWrappedTextWidget(String key, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.localeKey = key;
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.recalculate();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        double temp = this.yScroll - delta;
        this.yScroll = Mth.m_14008_((double)temp, (double)0.0, (double)(this.lines.size() - this.maxLinesToShow - 1));
        this.recalculate();
        return true;
    }

    private void recalculate() {
        String t = I18n.m_118938_((String)this.localeKey, (Object[])new Object[0]);
        this.lines = this.fontRenderer.m_92923_((FormattedText)new TextComponent(t), this.width);
        this.charSize = this.fontRenderer.m_92895_("M");
        int maxOnScreen = this.height / (this.charSize + 4);
        this.maxLinesToShow = Math.min(this.lines.size(), maxOnScreen);
        int startClamp = Math.min((int)Math.floor(this.yScroll), this.lines.size());
        this.lineIndexStart = Mth.m_14045_((int)0, (int)startClamp, (int)(this.lines.size() - 1));
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.x, (double)this.y, 10.0);
        Font fr = Minecraft.m_91087_().f_91062_;
        try {
            for (int y = this.lineIndexStart; y <= this.lineIndexStart + this.maxLinesToShow; ++y) {
                FormattedCharSequence s = this.lines.get(y);
                fr.m_92744_(matrixStack, s, 0.0f, (float)((y - this.lineIndexStart) * (this.charSize + 4)), 0xFFFFFF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrixStack.m_85849_();
    }
}

