/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.compactmods.machines.command.argument.RoomCoordinates;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.ChunkPos;

public class RoomPositionArgument
implements ArgumentType<RoomCoordinates> {
    public static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.pos2d.incomplete"));

    public static RoomPositionArgument room() {
        return new RoomPositionArgument();
    }

    public static ChunkPos get(CommandContext<CommandSourceStack> ctx, String room) {
        RoomCoordinates arg = (RoomCoordinates)ctx.getArgument(room, RoomCoordinates.class);
        return arg.get((CommandSourceStack)ctx.getSource());
    }

    public RoomCoordinates parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        if (!reader.canRead()) {
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)reader);
        }
        WorldCoordinate chunkX = WorldCoordinate.m_120869_((StringReader)reader);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            WorldCoordinate chunkZ = WorldCoordinate.m_120869_((StringReader)reader);
            return new RoomCoordinates(chunkX, chunkZ);
        }
        reader.setCursor(i);
        throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return Suggestions.empty();
    }
}

