/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.BitSet;
import java.util.List;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import mod.chiselsandbits.platforms.core.registries.IPlatformRegistryManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.material.Fluid;

public class FluidRenderingManager {
    private static final FluidRenderingManager INSTANCE = new FluidRenderingManager();
    private boolean renderTypesSetup = false;
    private final BitSet renderTypes = new BitSet(RenderType.m_110506_().size());

    public static FluidRenderingManager getInstance() {
        return INSTANCE;
    }

    private FluidRenderingManager() {
    }

    private void setupRenderTypes() {
        if (this.renderTypesSetup) {
            return;
        }
        this.renderTypes.clear();
        List blockRenderTypes = RenderType.m_110506_();
        block0: for (int i = 0; i < blockRenderTypes.size(); ++i) {
            RenderType renderType = (RenderType)blockRenderTypes.get(i);
            for (Fluid fluid : IPlatformRegistryManager.getInstance().getFluids().getValues()) {
                if (!IRenderTypeManager.getInstance().canRenderInType(fluid.m_76145_(), renderType)) continue;
                this.renderTypes.set(i);
                continue block0;
            }
        }
        this.renderTypesSetup = true;
    }

    public boolean isFluidRenderType(RenderType renderType) {
        this.setupRenderTypes();
        return this.renderTypes.get(RenderType.m_110506_().indexOf(renderType));
    }
}

