/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.platforms.core.registries.deferred.impl.custom;

import com.google.common.collect.Maps;
import java.util.Map;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistry;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistryEntry;
import mod.chiselsandbits.platforms.core.registries.deferred.ICustomRegistrar;
import mod.chiselsandbits.platforms.core.registries.deferred.impl.custom.CustomRegistrar;
import mod.chiselsandbits.platforms.core.registries.deferred.impl.custom.CustomRegistry;

public class CustomRegistryManager {
    private static final CustomRegistryManager INSTANCE = new CustomRegistryManager();
    private final Map<Class<?>, Map<String, CustomRegistrar<?>>> registrarMap = Maps.newConcurrentMap();

    public static CustomRegistryManager getInstance() {
        return INSTANCE;
    }

    private CustomRegistryManager() {
    }

    public <R extends T, T extends IChiselsAndBitsRegistryEntry> ICustomRegistrar<R> createNewRegistrar(Class<T> typeClass, String modId) {
        if (this.registrarMap.containsKey(typeClass) && this.registrarMap.get(typeClass).containsKey(modId)) {
            return this.registrarMap.get(typeClass).get(modId);
        }
        CustomRegistrar registrar = new CustomRegistrar(modId);
        this.registrarMap.computeIfAbsent(typeClass, k -> Maps.newConcurrentMap()).put(modId, registrar);
        return registrar;
    }

    public <T extends IChiselsAndBitsRegistryEntry> IChiselsAndBitsRegistry.Builder<T> createNewSimpleBuilder() {
        return new CustomRegistry.Builder();
    }
}

