/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.relationship;

import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mca.entity.EntitiesMCA;
import mca.entity.VillagerEntityMCA;
import mca.entity.ZombieVillagerEntityMCA;
import net.minecraft.world.entity.EntityType;

public enum Gender {
    UNASSIGNED(0xFFFFFF),
    MALE(108266),
    FEMALE(10897828),
    NEUTRAL(0xFFFFFF);

    private static final Random RNG;
    private static final Gender[] VALUES;
    private static final Map<String, Gender> REGISTRY;
    private final int color;

    private Gender(int color) {
        this.color = color;
    }

    public EntityType<VillagerEntityMCA> getVillagerType() {
        return this == FEMALE ? (EntityType)EntitiesMCA.FEMALE_VILLAGER.get() : (EntityType)EntitiesMCA.MALE_VILLAGER.get();
    }

    public EntityType<ZombieVillagerEntityMCA> getZombieType() {
        return this == FEMALE ? (EntityType)EntitiesMCA.FEMALE_ZOMBIE_VILLAGER.get() : (EntityType)EntitiesMCA.MALE_ZOMBIE_VILLAGER.get();
    }

    public int getColor() {
        return this.color;
    }

    public int getId() {
        return this.ordinal();
    }

    public String getStrName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public boolean isNonBinary() {
        return this == NEUTRAL || this == UNASSIGNED;
    }

    public Stream<Gender> getTransients() {
        return this.isNonBinary() ? Stream.of(MALE, FEMALE) : Stream.of(this);
    }

    public Gender binary() {
        return this == FEMALE ? FEMALE : MALE;
    }

    public Gender opposite() {
        return this == FEMALE ? MALE : FEMALE;
    }

    public boolean isAttractedTo(Gender other) {
        return other == UNASSIGNED || this == NEUTRAL || other != this;
    }

    public boolean isMutuallyAttracted(Gender other) {
        return this.isAttractedTo(other) && other.isAttractedTo(this);
    }

    public static Gender byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return UNASSIGNED;
        }
        return VALUES[id];
    }

    public static Gender getRandom() {
        return RNG.nextBoolean() ? MALE : FEMALE;
    }

    public static Gender byName(String name) {
        return REGISTRY.getOrDefault(name.toUpperCase(Locale.ENGLISH), UNASSIGNED);
    }

    static {
        RNG = new Random();
        VALUES = Gender.values();
        REGISTRY = Stream.of(VALUES).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

