/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import com.mojang.datafixers.util.Pair;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipeBuilder;
import dev.gigaherz.sewingkit.api.ToolActionIngredient;
import dev.gigaherz.sewingkit.needle.NeedleItem;
import dev.gigaherz.sewingkit.needle.Needles;
import dev.gigaherz.toolbelt.BeltFinderBeltSlot;
import dev.gigaherz.toolbelt.BeltFinderCurios;
import dev.gigaherz.toolbelt.Conditions;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.belt.BeltIngredient;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.client.ClientEvents;
import dev.gigaherz.toolbelt.common.BeltContainer;
import dev.gigaherz.toolbelt.common.BeltScreen;
import dev.gigaherz.toolbelt.common.BeltSlotContainer;
import dev.gigaherz.toolbelt.common.BeltSlotScreen;
import dev.gigaherz.toolbelt.customslots.ExtensionSlotItemCapability;
import dev.gigaherz.toolbelt.integration.SewingKitIntegration;
import dev.gigaherz.toolbelt.integration.SewingUpgradeRecipeBuilder;
import dev.gigaherz.toolbelt.network.BeltContentsChange;
import dev.gigaherz.toolbelt.network.ContainerSlotsHack;
import dev.gigaherz.toolbelt.network.OpenBeltSlotInventory;
import dev.gigaherz.toolbelt.network.SwapItems;
import dev.gigaherz.toolbelt.network.SyncBeltSlotContents;
import dev.gigaherz.toolbelt.slot.BeltExtensionSlot;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod(value="toolbelt")
public class ToolBelt {
    public static final String MODID = "toolbelt";
    @ObjectHolder(value="toolbelt:belt")
    public static ToolBeltItem BELT;
    @ObjectHolder(value="toolbelt:pouch")
    public static Item POUCH;
    @ObjectHolder(value="toolbelt:sewing_upgrade")
    public static RecipeSerializer<?> SEWING_UGRADE_SERIALIZER;
    public static ToolBelt instance;
    public static final Logger logger;
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;
    private static final Capability<ICuriosItemHandler> CURIOS;

    public ToolBelt() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(Item.class, this::registerItems);
        modEventBus.addGenericListener(RecipeSerializer.class, this::registerRecipes);
        modEventBus.addGenericListener(MenuType.class, this::registerContainers);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::modConfig);
        modEventBus.addListener(this::imcEnqueue);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::registerCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::anvilChange);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigData.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigData.COMMON_SPEC);
        if (ModList.get().isLoaded("sewingkit")) {
            SewingKitIntegration.init();
        }
    }

    public void gatherData(GatherDataEvent event) {
        DataGen.gatherData(event);
    }

    public void modConfig(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigData.CLIENT_SPEC) {
            ConfigData.refreshClient();
        } else if (config.getSpec() == ConfigData.SERVER_SPEC) {
            ConfigData.refreshServer();
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ToolBeltItem(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_)).setRegistryName("belt"), (Item)new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40756_)).setRegistryName("pouch")});
    }

    private void registerRecipes(RegistryEvent.Register<RecipeSerializer<?>> event) {
        CraftingHelper.register((ResourceLocation)BeltIngredient.NAME, BeltIngredient.Serializer.INSTANCE);
    }

    public void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new MenuType[]{(MenuType)new MenuType(BeltSlotContainer::new).setRegistryName("belt_slot_container"), (MenuType)IForgeMenuType.create(BeltContainer::new).setRegistryName("belt_container")});
        Conditions.register();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        ExtensionSlotItemCapability.register(event);
        event.register(BeltExtensionSlot.class);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.messageBuilder(SwapItems.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(SwapItems::encode).decoder(SwapItems::new).consumer(SwapItems::handle).add();
        channel.messageBuilder(BeltContentsChange.class, messageNumber++, NetworkDirection.PLAY_TO_CLIENT).encoder(BeltContentsChange::encode).decoder(BeltContentsChange::new).consumer(BeltContentsChange::handle).add();
        channel.messageBuilder(OpenBeltSlotInventory.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(OpenBeltSlotInventory::encode).decoder(OpenBeltSlotInventory::new).consumer(OpenBeltSlotInventory::handle).add();
        channel.messageBuilder(ContainerSlotsHack.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(ContainerSlotsHack::encode).decoder(ContainerSlotsHack::new).consumer(ContainerSlotsHack::handle).add();
        channel.messageBuilder(SyncBeltSlotContents.class, messageNumber++, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncBeltSlotContents::encode).decoder(SyncBeltSlotContents::new).consumer(SyncBeltSlotContents::handle).add();
        logger.debug("Final message number: " + messageNumber);
        BeltExtensionSlot.register();
        BeltFinderBeltSlot.initBaubles();
        CURIOS.addListener(cap -> BeltFinderCurios.initCurios());
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_(BeltContainer.TYPE, BeltScreen::new);
            MenuScreens.m_96206_(BeltSlotContainer.TYPE, BeltSlotScreen::new);
        });
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("belt").size(1).build());
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientEvents.initKeybinds();
            }
        });
    }

    public void anvilChange(AnvilUpdateEvent ev) {
        if (!ConfigData.enableAnvilUpgrading) {
            return;
        }
        ItemStack left = ev.getLeft();
        ItemStack right = ev.getRight();
        if (left.m_41613_() <= 0 || left.m_41720_() != BELT) {
            return;
        }
        if (right.m_41613_() <= 0 || right.m_41720_() != POUCH) {
            return;
        }
        int cost = ToolBeltItem.getUpgradeXP(left);
        if (cost < 0) {
            ev.setCanceled(true);
            return;
        }
        ev.setCost(cost);
        ev.setMaterialCost(1);
        ev.setOutput(ToolBeltItem.upgrade(left));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    private static TagKey<Item> itemTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(name));
    }

    static {
        SEWING_UGRADE_SERIALIZER = null;
        logger = LogManager.getLogger((String)MODID);
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ToolBelt.location("general")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
        CURIOS = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICuriosItemHandler>(){});
    }

    public static class DataGen {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            if (event.includeClient()) {
                // empty if block
            }
            if (event.includeServer()) {
                gen.m_123914_((DataProvider)new Recipes(gen));
            }
        }

        private static class Recipes
        extends RecipeProvider
        implements IConditionBuilder {
            public Recipes(DataGenerator gen) {
                super(gen);
            }

            protected void m_176531_(Consumer<FinishedRecipe> consumer) {
                ResourceLocation beltId = Objects.requireNonNull(BELT.getRegistryName());
                ConditionalRecipe.builder().addCondition((ICondition)new Conditions.EnableNormalCrafting()).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_((ItemLike)BELT).m_126130_("sls").m_126130_("l l").m_126130_("lil").m_126124_(Character.valueOf('s'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_})).m_126124_(Character.valueOf('l'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_})).m_126124_(Character.valueOf('i'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})).m_142284_("has_leather", (CriterionTriggerInstance)Recipes.m_206406_(ToolBelt.itemTag("forge:leather")))).m_176498_(arg_0)).generateAdvancement().build(consumer, beltId);
                ConditionalRecipe.builder().addCondition(this.modLoaded("sewingkit")).addCondition((ICondition)new Conditions.EnableSewingCrafting()).addRecipe(arg_0 -> ((SewingRecipeBuilder)SewingRecipeBuilder.begin((Item)BELT).withTool((Ingredient)ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.WOOD.getTier())).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SewingKitMod.LEATHER_STRIP.get()}), 2).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SewingKitMod.LEATHER_SHEET.get()}), 3).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), 1).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_}), 2).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_(ToolBelt.itemTag("forge:leather")))).build(arg_0)).generateAdvancement().build(consumer, new ResourceLocation(beltId.m_135827_(), beltId.m_135815_() + "_via_sewing"));
                ResourceLocation pouchId = Objects.requireNonNull(POUCH.getRegistryName());
                ConditionalRecipe.builder().addCondition((ICondition)new Conditions.EnableNormalCrafting()).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_((ItemLike)POUCH).m_126130_("sgs").m_126130_("l l").m_126130_("sls").m_126124_(Character.valueOf('s'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_})).m_126124_(Character.valueOf('l'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_})).m_126124_(Character.valueOf('g'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})).m_142284_("has_leather", (CriterionTriggerInstance)Recipes.m_206406_(ToolBelt.itemTag("forge:leather")))).m_176498_(arg_0)).generateAdvancement().build(consumer, pouchId);
                ConditionalRecipe.builder().addCondition(this.modLoaded("sewingkit")).addCondition((ICondition)new Conditions.EnableSewingCrafting()).addRecipe(arg_0 -> ((SewingRecipeBuilder)SewingRecipeBuilder.begin((Item)POUCH).withTool((Ingredient)ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.WOOD.getTier())).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SewingKitMod.LEATHER_STRIP.get()}), 2).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SewingKitMod.LEATHER_SHEET.get()}), 3).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_})).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_(ToolBelt.itemTag("forge:leather")))).build(arg_0)).generateAdvancement().build(consumer, new ResourceLocation(pouchId.m_135827_(), pouchId.m_135815_() + "_via_sewing"));
                ToolActionIngredient[] needleTiers = new ToolActionIngredient[]{ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.WOOD.getTier()), ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.BONE.getTier()), ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.IRON.getTier()), ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.IRON.getTier()), ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.DIAMOND.getTier()), ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.DIAMOND.getTier()), ToolActionIngredient.fromTool((ToolAction)NeedleItem.SEW, (Tier)Needles.NETHERITE.getTier())};
                for (int i = 0; i < 7; ++i) {
                    ConditionalRecipe.builder().addCondition(this.modLoaded("sewingkit")).addCondition((ICondition)new Conditions.EnableSewingCrafting()).addRecipe(arg_0 -> ((SewingRecipeBuilder)SewingUpgradeRecipeBuilder.begin(BELT, this.compound(Pair.of((Object)"Size", (Object)IntTag.m_128679_((int)(i + 3))))).withTool((Ingredient)needleTiers[i]).addMaterial((Ingredient)BeltIngredient.withLevel(i)).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{POUCH})).addMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_})).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.m_206406_(ToolBelt.itemTag("forge:leather")))).build(arg_0)).generateAdvancement().build(consumer, new ResourceLocation(pouchId.m_135827_(), pouchId.m_135815_() + "_upgrade_" + (i + 1) + "_via_sewing"));
                }
            }

            public final ItemStack stack(ItemLike item, CompoundTag tag) {
                ItemStack stack = new ItemStack(item);
                stack.m_41751_(tag);
                return stack;
            }

            @SafeVarargs
            public final CompoundTag compound(Pair<String, Tag> ... entries) {
                CompoundTag tag = new CompoundTag();
                for (Pair<String, Tag> entry : entries) {
                    tag.m_128365_((String)entry.getFirst(), (Tag)entry.getSecond());
                }
                return tag;
            }
        }
    }
}

