/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.common;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageExecuteTrade;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.ITraderSource;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;

public class TraderInteractionTab
extends TraderClientTab {
    TradeButtonArea tradeDisplay;

    public TraderInteractionTab(TraderScreen screen) {
        super(screen);
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButtonArea(this.menu.traderSource, this.menu::getContext, this.screen.getGuiLeft() + 3, this.screen.getGuiTop() + 17, this.screen.getXSize() - 6, 100, 2, this.screen::addRenderableTabWidget, this.screen::removeRenderableTabWidget, this::OnButtonPress, TradeButtonArea.FILTER_VALID));
        this.tradeDisplay.init();
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.tradeDisplay.renderTraderName(pose, this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 6, this.screen.getXSize() - 16, false);
        this.tradeDisplay.getScrollBar().beforeWidgetRender(mouseY);
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        if (this.menu.m_142621_().m_41619_()) {
            this.tradeDisplay.renderTooltips((Screen)this.screen, pose, this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 6, this.screen.getXSize() - 16, mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        this.tradeDisplay.tick();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.getScrollBar().onMouseClicked(mouseX, mouseY, button);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.tradeDisplay.getScrollBar().onMouseReleased(mouseX, mouseY, button);
        return false;
    }

    private void OnButtonPress(ITrader trader, TradeButton.ITradeData trade) {
        if (trader == null || trade == null) {
            return;
        }
        ITraderSource ts = this.menu.traderSource.get();
        if (ts == null) {
            this.menu.player.m_6915_();
            return;
        }
        List<ITrader> traders = ts.getTraders();
        int ti = traders.indexOf(trader);
        if (ti < 0) {
            return;
        }
        ITrader t = traders.get(ti);
        if (t == null) {
            return;
        }
        int tradeIndex = t.getTradeInfo().indexOf(trade);
        if (tradeIndex < 0) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageExecuteTrade(ti, tradeIndex));
    }
}

