/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.lightman314.lightmanscurrency.client.ModLayerDefinitions;
import io.github.lightman314.lightmanscurrency.client.model.ModelWallet;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class WalletLayer<T extends Player, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private ModelWallet<T> model = new ModelWallet(Minecraft.m_91087_().m_167973_().m_171103_(ModLayerDefinitions.WALLET));

    public WalletLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IWalletHandler handler = (IWalletHandler)WalletCapability.getWalletHandler(entity).orElse(null);
        if (handler == null || !handler.visible()) {
            return;
        }
        ItemStack wallet = handler.getWallet();
        if (wallet.m_41720_() instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)wallet.m_41720_();
            this.model.m_6839_((LivingEntity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ((HumanoidModel)this.m_117386_()).m_102872_(this.model);
            VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferSource, (RenderType)this.model.m_103119_(walletItem.getModelTexture()), (boolean)false, (boolean)wallet.m_41790_());
            this.model.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static LayerDefinition createLayer() {
        CubeDeformation cube = CubeDeformation.f_171458_;
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)cube, (float)0.0f);
        PartDefinition part = mesh.m_171576_();
        part.m_171599_("wallet", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(4.0f, 11.5f, -2.0f, 2.0f, 4.0f, 4.0f, cube), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)16);
    }
}

