/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.auction;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class PersistentAuctionData {
    public final String id;
    public final long duration;
    private final List<ItemStack> items;
    private final CoinValue startBid;
    private final CoinValue minBid;

    public final List<ItemStack> getAuctionItems() {
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            copy.add(stack.m_41777_());
        }
        return copy;
    }

    public final CoinValue getStartingBid() {
        return this.startBid.copy();
    }

    public final CoinValue getMinimumBidDifference() {
        return this.minBid;
    }

    private PersistentAuctionData(String id, long duration, List<ItemStack> items, CoinValue startBid, CoinValue minBid) {
        this.id = id;
        this.duration = duration;
        this.items = items;
        this.startBid = startBid;
        this.minBid = minBid;
    }

    public AuctionTradeData createAuction() {
        return new AuctionTradeData(this);
    }

    public static PersistentAuctionData load(JsonObject json) throws Exception {
        if (!json.has("id")) {
            throw new Exception("Auction was not given a valid 'id' entry!");
        }
        String id = json.get("id").getAsString();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (json.has("Item1")) {
            items.add(FileUtil.parseItemStack(json.getAsJsonObject("Item1")));
        }
        if (json.has("Item2")) {
            items.add(FileUtil.parseItemStack(json.getAsJsonObject("Item2")));
        }
        if (items.size() <= 0) {
            throw new Exception("Auction has no 'Item1' or 'Item2' entry!");
        }
        long duration = 0L;
        duration = json.has("Duration") ? Math.max(json.get("Duration").getAsLong(), 3600000L) : 86400000L;
        if (!json.has("StartingBid")) {
            throw new Exception("Auction has no 'StartingBid' entry!");
        }
        CoinValue startingBid = CoinValue.Parse(json.get("StartingBid"));
        CoinValue minimumBid = new CoinValue(1L);
        if (json.has("MinimumBid")) {
            minimumBid = CoinValue.Parse(json.get("MinimumBid"));
        }
        return new PersistentAuctionData(id, duration, items, startingBid, minimumBid);
    }
}

