/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.core.ModMenus;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ATMMenu
extends AbstractContainerMenu
implements BankAccount.IBankAccountAdvancedMenu {
    private Player player;
    private final Container coinInput = new SimpleContainer(9);
    private MutableComponent transferMessage = null;

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Container getCoinInput() {
        return this.coinInput;
    }

    public ATMMenu(int windowId, Inventory inventory) {
        super(ModMenus.ATM, windowId);
        int x;
        this.player = inventory.f_35978_;
        for (x = 0; x < this.coinInput.m_6643_(); ++x) {
            this.m_38897_(new CoinSlot(this.coinInput, x, 8 + x * 18, 129, false));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 161 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 219));
        }
    }

    public boolean m_6875_(Player playerIn) {
        this.getBankAccountReference();
        return true;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.coinInput);
        if (!this.isClient()) {
            BankAccount.AccountReference account = this.getBankAccountReference();
            if (account.accountType == BankAccount.AccountType.Player && !account.id.equals(this.player.m_142081_())) {
                TradingOffice.setSelectedBankAccount(this.player, BankAccount.GenerateReference(this.player));
            }
        }
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.coinInput.m_6643_() ? MoneyUtil.isCoin(slotStack.m_41720_()) && !this.m_38903_(slotStack, this.coinInput.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.coinInput.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void ConvertCoins(String command) {
        if (command.contentEquals("convertAllUp")) {
            MoneyUtil.ConvertAllCoinsUp(this.coinInput);
        } else if (command.startsWith("convertUp-")) {
            ResourceLocation coinID = null;
            String id = "";
            try {
                id = command.substring("convertUp-".length());
                coinID = new ResourceLocation(id);
                Item coinItem = (Item)ForgeRegistries.ITEMS.getValue(coinID);
                if (coinItem == null) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is not a registered item.");
                    return;
                }
                if (!MoneyUtil.isCoin(coinItem)) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is not a coin.");
                    return;
                }
                if (MoneyUtil.getUpwardConversion(coinItem) == null) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is the largest visible coin in its chain, and thus cannot be converted any larger.");
                    return;
                }
                MoneyUtil.ConvertCoinsUp(this.coinInput, coinItem);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + id + "' could not be parsed as an item id.", e);
            }
        } else if (command.contentEquals("convertAllDown")) {
            MoneyUtil.ConvertAllCoinsDown(this.coinInput);
        } else if (command.startsWith("convertDown-")) {
            String id = "";
            try {
                id = command.substring("convertDown-".length());
                ResourceLocation coinID = new ResourceLocation(id);
                Item coinItem = (Item)ForgeRegistries.ITEMS.getValue(coinID);
                if (coinItem == null) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is not a registered item.");
                    return;
                }
                if (!MoneyUtil.isCoin(coinItem)) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is not a coin.");
                    return;
                }
                if (MoneyUtil.getDownwardConversion(coinItem) == null) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is the smallest known coin, and thus cannot be converted any smaller.");
                    return;
                }
                MoneyUtil.ConvertCoinsDown(this.coinInput, coinItem);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + id + "' could not be parsed as an item id.", e);
            }
        } else {
            LightmansCurrency.LogError("'" + command + "' is not a valid ATM Conversion command.");
        }
    }

    public MutableComponent SetPlayerAccount(String playerName) {
        if (TradingOffice.isAdminPlayer(this.player)) {
            PlayerReference accountPlayer = PlayerReference.of(playerName);
            if (accountPlayer != null) {
                TradingOffice.setSelectedBankAccount(this.player, BankAccount.GenerateReference(false, accountPlayer));
                return new TranslatableComponent("gui.bank.select.player.success", new Object[]{accountPlayer.lastKnownName()});
            }
            return new TranslatableComponent("gui.bank.transfer.error.null.to");
        }
        return new TextComponent("ERROR");
    }

    public boolean hasTransferMessage() {
        return this.transferMessage != null;
    }

    public MutableComponent getTransferMessage() {
        return this.transferMessage;
    }

    @Override
    public void setTransferMessage(MutableComponent message) {
        this.transferMessage = message;
    }

    public void clearMessage() {
        this.transferMessage = null;
    }

    @Override
    public boolean isClient() {
        return this.player.f_19853_.f_46443_;
    }
}

