/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.tconstruct;

import com.simibubi.create.api.behaviour.BlockSpoutingBehaviour;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.contraptions.fluids.actors.SpoutTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SpoutCasting
extends BlockSpoutingBehaviour {
    static Boolean TICON_PRESENT = null;
    ResourceLocation TABLE = new ResourceLocation("tconstruct", "table");
    ResourceLocation BASIN = new ResourceLocation("tconstruct", "basin");

    @Override
    public int fillBlock(Level level, BlockPos pos, SpoutTileEntity spout, FluidStack availableFluid, boolean simulate) {
        if (!this.enabled()) {
            return 0;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te == null) {
            return 0;
        }
        IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP).orElse(null);
        if (handler == null) {
            return 0;
        }
        if (handler.getTanks() != 1) {
            return 0;
        }
        ResourceLocation registryName = te.m_58903_().getRegistryName();
        if (!registryName.equals((Object)this.TABLE) && !registryName.equals((Object)this.BASIN)) {
            return 0;
        }
        if (!handler.isFluidValid(0, availableFluid)) {
            return 0;
        }
        FluidStack containedFluid = handler.getFluidInTank(0);
        if (!containedFluid.isEmpty() && !containedFluid.isFluidEqual(availableFluid)) {
            return 0;
        }
        int amount = availableFluid.getAmount();
        if (amount < 1000 && handler.fill(FluidHelper.copyStackWithAmount(availableFluid, amount + 1), IFluidHandler.FluidAction.SIMULATE) > amount) {
            return 0;
        }
        return handler.fill(availableFluid, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    private boolean enabled() {
        if (TICON_PRESENT == null) {
            TICON_PRESENT = Mods.TCONSTRUCT.isLoaded();
        }
        if (!TICON_PRESENT.booleanValue()) {
            return false;
        }
        return (Boolean)AllConfigs.SERVER.recipes.allowCastingBySpout.get();
    }
}

