/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.components.crank.ValveHandleBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.DoorMovingInteraction;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.TrapdoorMovingInteraction;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonGenerator;
import com.simibubi.create.content.contraptions.relays.encased.CasingConnectivity;
import com.simibubi.create.content.contraptions.relays.encased.EncasedCTBehaviour;
import com.simibubi.create.content.contraptions.relays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.content.contraptions.relays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.contraptions.relays.encased.EncasedShaftBlock;
import com.simibubi.create.content.curiosities.deco.SlidingDoorBlock;
import com.simibubi.create.content.curiosities.deco.SlidingDoorMovementBehaviour;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelItem;
import com.simibubi.create.content.logistics.trains.IBogeyBlock;
import com.simibubi.create.content.logistics.trains.track.StandardBogeyBlock;
import com.simibubi.create.foundation.block.BlockStressDefaults;
import com.simibubi.create.foundation.block.ItemUseOverrides;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import com.simibubi.create.repack.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class BuilderTransformers {
    public static <B extends EncasedShaftBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> encasedShaft(String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        return builder -> (BlockBuilder)((BlockBuilder)((BlockBuilder)BuilderTransformers.encasedBase(builder, () -> (ItemLike)AllBlocks.SHAFT.get()).onRegister(CreateRegistrate.connectedTextures(() -> BuilderTransformers.lambda$encasedShaft$1((Supplier)casingShift)))).onRegister(CreateRegistrate.casingConnectivity((arg_0, arg_1) -> BuilderTransformers.lambda$encasedShaft$3((Supplier)casingShift, arg_0, arg_1)))).blockstate((c, p) -> BlockStateGen.axisBlock(c, p, blockState -> p.models().getExistingFile(p.modLoc("block/encased_shaft/block_" + casing)), true)).item().model(AssetLookup.customBlockItemModel("encased_shaft", "item_" + casing)).build();
    }

    public static <B extends StandardBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> bogey() {
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(p -> p.m_60955_()).transform(AllTags.pickaxeOnly()).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock(c, p, s -> p.models().getExistingFile(p.modLoc("block/track/bogey/top")))).loot((p, l) -> p.m_124147_(l, (ItemLike)AllBlocks.RAILWAY_CASING.get())).onRegister(block -> IBogeyBlock.register(block.getRegistryName()));
    }

    public static <B extends TrapDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> trapdoor(boolean orientable) {
        return b -> (BlockBuilder)((BlockBuilder)b.blockstate((c, p) -> {
            ModelFile bottom = AssetLookup.partialBaseModel(c, p, "bottom");
            ModelFile top = AssetLookup.partialBaseModel(c, p, "top");
            ModelFile open = AssetLookup.partialBaseModel(c, p, "open");
            if (orientable) {
                p.trapdoorBlock((TrapDoorBlock)c.get(), bottom, top, open, orientable);
            } else {
                BlockStateGen.uvLockedTrapdoorBlock((TrapDoorBlock)c.get(), bottom, top, open).accept((DataGenContext<Block, TrapDoorBlock>)c, (RegistrateBlockstateProvider)p);
            }
        }).transform(AllTags.pickaxeOnly()).tag(BlockTags.f_13036_).onRegister(AllInteractionBehaviours.interactionBehaviour(new TrapdoorMovingInteraction()))).item().tag(ItemTags.f_13144_).build();
    }

    public static <B extends SlidingDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> slidingDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(Material.f_76321_).properties(p -> p.m_60999_().m_60913_(3.0f, 6.0f)).blockstate((c, p) -> {
            ModelFile bottom = AssetLookup.partialBaseModel(c, p, "bottom");
            ModelFile top = AssetLookup.partialBaseModel(c, p, "top");
            p.doorBlock((DoorBlock)c.get(), bottom, bottom, top, top);
        }).addLayer(() -> RenderType::m_110457_).transform(AllTags.pickaxeOnly()).onRegister(AllInteractionBehaviours.interactionBehaviour(new DoorMovingInteraction()))).onRegister(AllMovementBehaviours.movementBehaviour(new SlidingDoorMovementBehaviour()))).tag(BlockTags.f_13103_).tag(BlockTags.f_13095_).tag(AllTags.AllBlockTags.NON_DOUBLE_DOOR.tag).loot((lr, block) -> lr.m_124165_((Block)block, BlockLoot.m_124137_((Block)block))).item().tag(ItemTags.f_13179_).model((c, p) -> p.blockSprite((NonNullSupplier<? extends ItemLike>)c, p.modLoc("item/" + type + "_door"))).build();
    }

    public static <B extends EncasedCogwheelBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> encasedCogwheel(String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        return b -> BuilderTransformers.encasedCogwheelBase(b, casing, casingShift, () -> (ItemLike)AllBlocks.COGWHEEL.get(), false);
    }

    public static <B extends EncasedCogwheelBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> encasedLargeCogwheel(String casing, Supplier<CTSpriteShiftEntry> casingShift) {
        return b -> (BlockBuilder)BuilderTransformers.encasedCogwheelBase(b, casing, casingShift, () -> (ItemLike)AllBlocks.LARGE_COGWHEEL.get(), true).onRegister(CreateRegistrate.connectedTextures(() -> BuilderTransformers.lambda$encasedLargeCogwheel$25((Supplier)casingShift)));
    }

    private static <B extends EncasedCogwheelBlock, P> BlockBuilder<B, P> encasedCogwheelBase(BlockBuilder<B, P> b, String casing, Supplier<CTSpriteShiftEntry> casingShift, Supplier<ItemLike> drop, boolean large) {
        String encasedSuffix = "_encased_cogwheel_side" + (large ? "_connected" : "");
        String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
        String wood = casing.equals("brass") ? "dark_oak" : "spruce";
        return (BlockBuilder)((BlockBuilder)BuilderTransformers.encasedBase(b, drop).addLayer(() -> RenderType::m_110457_).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, (CTSpriteShiftEntry)casingShift.get(), (s, f) -> f.m_122434_() == s.m_61143_((Property)EncasedCogwheelBlock.AXIS) && (Boolean)s.m_61143_((Property)(f.m_122421_() == Direction.AxisDirection.POSITIVE ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT)) == false)))).blockstate((c, p) -> BlockStateGen.axisBlock(c, p, blockState -> {
            String suffix = ((Boolean)blockState.m_61143_((Property)EncasedCogwheelBlock.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.m_61143_((Property)EncasedCogwheelBlock.BOTTOM_SHAFT) != false ? "_bottom" : "");
            String modelName = c.getName() + suffix;
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(modelName, p.modLoc("block/" + blockFolder + "/block" + suffix))).texture("casing", Create.asResource("block/" + casing + "_casing"))).texture("1", new ResourceLocation("block/stripped_" + wood + "_log_top"))).texture("side", Create.asResource("block/" + casing + encasedSuffix));
        }, false)).item().model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), p.modLoc("block/" + blockFolder + "/item"))).texture("casing", Create.asResource("block/" + casing + "_casing"))).texture("1", new ResourceLocation("block/stripped_" + wood + "_log_top"))).texture("side", Create.asResource("block/" + casing + encasedSuffix))).build();
    }

    private static <B extends RotatedPillarKineticBlock, P> BlockBuilder<B, P> encasedBase(BlockBuilder<B, P> b, Supplier<ItemLike> drop) {
        return ((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).transform(BlockStressDefaults.setNoImpact())).loot((p, lb) -> p.m_124147_(lb, (ItemLike)drop.get()));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> cuckooClock() {
        return b -> (BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::wooden).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(p.modLoc("block/cuckoo_clock/block")))).addLayer(() -> RenderType::m_110457_).transform(BlockStressDefaults.setImpact(1.0))).item().transform(ModelGen.customItemModel("cuckoo_clock", "item"));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> ladder(String name, Supplier<DataIngredient> ingredient) {
        return b -> (BlockBuilder)b.initialProperties(() -> Blocks.f_50155_).addLayer(() -> RenderType::m_110463_).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), p.modLoc("block/ladder"))).texture("0", p.modLoc("block/ladder_" + name + "_hoop"))).texture("1", p.modLoc("block/ladder_" + name))).texture("particle", p.modLoc("block/ladder_" + name)))).properties(p -> p.m_60918_(SoundType.f_154663_)).transform(AllTags.pickaxeOnly()).tag(BlockTags.f_13082_).item().recipe((arg_0, arg_1) -> BuilderTransformers.lambda$ladder$41(name, (Supplier)ingredient, arg_0, arg_1)).model((c, p) -> p.blockSprite(c::get, p.modLoc("block/ladder_" + name))).build();
    }

    public static <B extends ValveHandleBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> valveHandle(@Nullable DyeColor color) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::copperMetal).blockstate((c, p) -> {
            String variant = color == null ? "copper" : color.m_7912_();
            p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)p.models().withExistingParent(variant + "_valve_handle", p.modLoc("block/valve_handle"))).texture("3", p.modLoc("block/valve_handle/valve_handle_" + variant)));
        }).tag(AllTags.AllBlockTags.BRITTLE.tag, AllTags.AllBlockTags.VALVE_HANDLES.tag).transform(BlockStressDefaults.setCapacity(8.0))).transform(BlockStressDefaults.setGeneratorSpeed(ValveHandleBlock::getSpeedRange))).onRegister(ItemUseOverrides::addBlock)).item().tag(AllTags.AllItemTags.VALVE_HANDLES.tag).build();
    }

    public static <B extends CasingBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> casing(Supplier<CTSpriteShiftEntry> ct) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(p -> p.m_60918_(SoundType.f_56736_)).transform(AllTags.axeOrPickaxe()).blockstate((c, p) -> p.simpleBlock((Block)c.get())).onRegister(CreateRegistrate.connectedTextures(() -> BuilderTransformers.lambda$casing$48((Supplier)ct)))).onRegister(CreateRegistrate.casingConnectivity((arg_0, arg_1) -> BuilderTransformers.lambda$casing$49((Supplier)ct, arg_0, arg_1)))).tag(AllTags.AllBlockTags.CASING.tag).item().tag(AllTags.AllItemTags.CASING.tag).build();
    }

    public static <B extends CasingBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> layeredCasing(Supplier<CTSpriteShiftEntry> ct, Supplier<CTSpriteShiftEntry> ct2) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::stone).transform(AllTags.axeOrPickaxe()).blockstate((arg_0, arg_1) -> BuilderTransformers.lambda$layeredCasing$51((Supplier)ct, (Supplier)ct2, arg_0, arg_1)).onRegister(CreateRegistrate.connectedTextures(() -> BuilderTransformers.lambda$layeredCasing$52((Supplier)ct, (Supplier)ct2)))).onRegister(CreateRegistrate.casingConnectivity((arg_0, arg_1) -> BuilderTransformers.lambda$layeredCasing$53((Supplier)ct, arg_0, arg_1)))).tag(AllTags.AllBlockTags.CASING.tag).item().tag(AllTags.AllItemTags.CASING.tag).build();
    }

    public static <B extends BeltTunnelBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> beltTunnel(String type, ResourceLocation particleTexture) {
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::stone).addLayer(() -> RenderType::m_110457_).properties(BlockBehaviour.Properties::m_60955_).transform(AllTags.pickaxeOnly()).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            String id = "block/" + type + "_tunnel";
            BeltTunnelBlock.Shape shape = (BeltTunnelBlock.Shape)((Object)((Object)((Object)((Object)state.m_61143_(BeltTunnelBlock.SHAPE)))));
            if (shape == BeltTunnelBlock.Shape.CLOSED) {
                shape = BeltTunnelBlock.Shape.STRAIGHT;
            }
            String shapeName = shape.m_7912_();
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(id + "/" + shapeName, p.modLoc("block/belt_tunnel/" + shapeName))).texture("1", p.modLoc(id + "_top"))).texture("2", p.modLoc(id))).texture("3", p.modLoc(id + "_top_window"))).texture("particle", particleTexture)).rotationY(state.m_61143_(BeltTunnelBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? 0 : 90).build();
        })).item(BeltTunnelItem::new).model((c, p) -> {
            String id = type + "_tunnel";
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent("item/" + id, p.modLoc("block/belt_tunnel/item"))).texture("1", p.modLoc("block/" + id + "_top"))).texture("2", p.modLoc("block/" + id))).texture("particle", particleTexture);
        }).build();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> mechanicalPiston(PistonType type) {
        return b -> (BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(p -> p.m_60955_()).blockstate(new MechanicalPistonGenerator(type)::generate).addLayer(() -> RenderType::m_110457_).transform(BlockStressDefaults.setImpact(4.0))).item().transform(ModelGen.customItemModel("mechanical_piston", type.m_7912_(), "item"));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> bearing(String prefix, String backTexture, boolean woodenTop) {
        ResourceLocation baseBlockModelLocation = Create.asResource("block/bearing/block");
        ResourceLocation baseItemModelLocation = Create.asResource("block/bearing/item");
        ResourceLocation topTextureLocation = Create.asResource("block/bearing_top" + (woodenTop ? "_wooden" : ""));
        ResourceLocation nookTextureLocation = Create.asResource("block/" + (woodenTop ? "andesite" : "brass") + "_casing");
        ResourceLocation sideTextureLocation = Create.asResource("block/" + prefix + "_bearing_side");
        ResourceLocation backTextureLocation = Create.asResource("block/" + backTexture);
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::stone).properties(p -> p.m_60955_()).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseBlockModelLocation)).texture("side", sideTextureLocation)).texture("nook", nookTextureLocation)).texture("back", backTextureLocation))).item().model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), baseItemModelLocation)).texture("top", topTextureLocation)).texture("side", sideTextureLocation)).texture("back", backTextureLocation)).build();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> crate(String type) {
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::stone).transform(AllTags.axeOrPickaxe()).blockstate((c, p) -> {
            String[] variants = new String[]{"single", "top", "bottom", "left", "right"};
            HashMap<String, ModelBuilder> models = new HashMap<String, ModelBuilder>();
            ResourceLocation crate = p.modLoc("block/crate_" + type);
            ResourceLocation side = p.modLoc("block/crate_" + type + "_side");
            ResourceLocation casing = p.modLoc("block/" + type + "_casing");
            for (String variant : variants) {
                models.put(variant, ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/crate/" + type + "/" + variant, p.modLoc("block/crate/" + variant))).texture("crate", crate)).texture("side", side)).texture("casing", casing));
            }
            p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
                String variant = "single";
                return ConfiguredModel.builder().modelFile((ModelFile)models.get(variant)).build();
            });
        }).item().properties(p -> type.equals("creative") ? p.m_41497_(Rarity.EPIC) : p).transform(ModelGen.customItemModel("crate", type, "single"));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> bell() {
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60955_().m_60918_(SoundType.f_56749_)).transform(AllTags.pickaxeOnly()).addLayer(() -> RenderType::m_110457_).tag(AllTags.AllBlockTags.BRITTLE.tag).blockstate((c, p) -> p.horizontalBlock((Block)c.getEntry(), state -> {
            String variant = ((BellAttachType)state.m_61143_((Property)BlockStateProperties.f_61377_)).m_7912_();
            return p.models().withExistingParent(c.getName() + "_" + variant, p.modLoc("block/bell_base/block_" + variant));
        })).item().model((c, p) -> p.withExistingParent(c.getName(), p.modLoc("block/" + c.getName()))).build();
    }

    private static /* synthetic */ void lambda$layeredCasing$53(Supplier ct, CasingBlock block, CasingConnectivity cc) {
        cc.makeCasing(block, (CTSpriteShiftEntry)ct.get());
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$layeredCasing$52(Supplier ct, Supplier ct2) {
        return new HorizontalCTBehaviour((CTSpriteShiftEntry)ct.get(), (CTSpriteShiftEntry)ct2.get());
    }

    private static /* synthetic */ void lambda$layeredCasing$51(Supplier ct, Supplier ct2, DataGenContext c, RegistrateBlockstateProvider p) {
        p.simpleBlock((Block)c.get(), (ModelFile)p.models().cubeColumn(c.getName(), ((CTSpriteShiftEntry)ct.get()).getOriginalResourceLocation(), ((CTSpriteShiftEntry)ct2.get()).getOriginalResourceLocation()));
    }

    private static /* synthetic */ void lambda$casing$49(Supplier ct, CasingBlock block, CasingConnectivity cc) {
        cc.makeCasing(block, (CTSpriteShiftEntry)ct.get());
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$casing$48(Supplier ct) {
        return new EncasedCTBehaviour((CTSpriteShiftEntry)ct.get());
    }

    private static /* synthetic */ void lambda$ladder$41(String name, Supplier ingredient, DataGenContext c, RegistrateRecipeProvider p) {
        if (name.equals("andesite")) {
            return;
        }
        p.stonecutting((DataIngredient)((Object)ingredient.get()), c::get, 2);
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$encasedLargeCogwheel$25(Supplier casingShift) {
        return new EncasedCogCTBehaviour((CTSpriteShiftEntry)casingShift.get());
    }

    private static /* synthetic */ void lambda$encasedShaft$3(Supplier casingShift, EncasedShaftBlock block, CasingConnectivity cc) {
        cc.make(block, (CTSpriteShiftEntry)casingShift.get(), (s, f) -> f.m_122434_() != s.m_61143_((Property)EncasedShaftBlock.AXIS));
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$encasedShaft$1(Supplier casingShift) {
        return new EncasedCTBehaviour((CTSpriteShiftEntry)casingShift.get());
    }
}

