/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.goggles.GogglesItem;
import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CKinetics;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class ItemDescription {
    public static final ItemDescription MISSING = new ItemDescription(null);
    public static Component trim = new TextComponent("                          ").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.STRIKETHROUGH});
    private List<Component> lines;
    private List<Component> linesOnShift;
    private List<Component> linesOnCtrl;
    private Palette palette;

    public ItemDescription(Palette palette) {
        this.palette = palette;
        this.lines = new ArrayList<Component>();
        this.linesOnShift = new ArrayList<Component>();
        this.linesOnCtrl = new ArrayList<Component>();
    }

    public ItemDescription withSummary(Component summary) {
        ItemDescription.addStrings(this.linesOnShift, TooltipHelper.cutTextComponent(summary, this.palette.color, this.palette.hColor));
        return this;
    }

    public static List<Component> getKineticStats(Block block) {
        boolean hasStressCapacity;
        ArrayList<Component> list = new ArrayList<Component>();
        CKinetics config = AllConfigs.SERVER.kinetics;
        LangBuilder rpmUnit = Lang.translate("generic.unit.rpm", new Object[0]);
        LangBuilder suUnit = Lang.translate("generic.unit.stress", new Object[0]);
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)Minecraft.m_91087_().f_91074_);
        boolean showStressImpact = !(block instanceof IRotate) ? true : !((IRotate)block).hideStressImpact();
        boolean hasStressImpact = IRotate.StressImpact.isEnabled() && showStressImpact && BlockStressValues.getImpact(block) > 0.0;
        boolean bl = hasStressCapacity = IRotate.StressImpact.isEnabled() && BlockStressValues.hasCapacity(block);
        if (hasStressImpact) {
            Lang.translate("tooltip.stressImpact", new Object[0]).style(ChatFormatting.GRAY).addTo(list);
            double impact = BlockStressValues.getImpact(block);
            IRotate.StressImpact impactId = impact >= (Double)config.highStressImpact.get() ? IRotate.StressImpact.HIGH : (impact >= (Double)config.mediumStressImpact.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            LangBuilder builder = Lang.builder().add(Lang.text(ItemDescription.makeProgressBar(3, impactId.ordinal() + 1)).style(impactId.getAbsoluteColor()));
            if (hasGoggles) {
                builder.add(Lang.number(impact)).text("x ").add(rpmUnit).addTo(list);
            } else {
                builder.translate("tooltip.stressImpact." + Lang.asId(impactId.name()), new Object[0]).addTo(list);
            }
        }
        if (hasStressCapacity) {
            Couple<Integer> generatedRPM;
            Lang.translate("tooltip.capacityProvided", new Object[0]).style(ChatFormatting.GRAY).addTo(list);
            double capacity = BlockStressValues.getCapacity(block);
            BlockStressValues.IStressValueProvider stressProvider = BlockStressValues.getProvider(block);
            Couple<Integer> couple = generatedRPM = stressProvider != null ? stressProvider.getGeneratedRPM(block) : null;
            IRotate.StressImpact impactId = capacity >= (Double)config.highCapacity.get() ? IRotate.StressImpact.HIGH : (capacity >= (Double)config.mediumCapacity.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            IRotate.StressImpact opposite = IRotate.StressImpact.values()[IRotate.StressImpact.values().length - 2 - impactId.ordinal()];
            LangBuilder builder = Lang.builder().add(Lang.text(ItemDescription.makeProgressBar(3, impactId.ordinal() + 1)).style(opposite.getAbsoluteColor()));
            if (hasGoggles) {
                builder.add(Lang.number(capacity)).text("x ").add(rpmUnit).addTo(list);
                if (generatedRPM != null) {
                    LangBuilder amount = Lang.number(capacity * (double)((Integer)generatedRPM.getSecond()).intValue()).add(suUnit);
                    Lang.text(" -> ").add(!((Integer)generatedRPM.getFirst()).equals(generatedRPM.getSecond()) ? Lang.translate("tooltip.up_to", amount) : amount).style(ChatFormatting.DARK_GRAY).addTo(list);
                }
            } else {
                builder.translate("tooltip.capacityProvided." + Lang.asId(impactId.name()), new Object[0]).addTo(list);
            }
        }
        return list;
    }

    public static String makeProgressBar(int length, int filledLength) {
        int i;
        Object bar = " ";
        int emptySpaces = length - filledLength;
        for (i = 0; i < filledLength; ++i) {
            bar = (String)bar + "\u2588";
        }
        for (i = 0; i < emptySpaces; ++i) {
            bar = (String)bar + "\u2592";
        }
        return (String)bar + " ";
    }

    public ItemDescription withBehaviour(String condition, String behaviour) {
        ItemDescription.add(this.linesOnShift, (Component)new TextComponent(condition).m_130940_(ChatFormatting.GRAY));
        ItemDescription.addStrings(this.linesOnShift, TooltipHelper.cutStringTextComponent(behaviour, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription withControl(String condition, String action) {
        ItemDescription.add(this.linesOnCtrl, (Component)new TextComponent(condition).m_130940_(ChatFormatting.GRAY));
        ItemDescription.addStrings(this.linesOnCtrl, TooltipHelper.cutStringTextComponent(action, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription createTabs() {
        boolean hasControls;
        boolean hasDescription = !this.linesOnShift.isEmpty();
        boolean bl = hasControls = !this.linesOnCtrl.isEmpty();
        if (hasDescription || hasControls) {
            String[] holdDesc = Lang.translateDirect("tooltip.holdForDescription", "$").getString().split("\\$");
            String[] holdCtrl = Lang.translateDirect("tooltip.holdForControls", "$").getString().split("\\$");
            TranslatableComponent keyShift = Lang.translateDirect("tooltip.keyShift", new Object[0]);
            TranslatableComponent keyCtrl = Lang.translateDirect("tooltip.keyCtrl", new Object[0]);
            for (List list : Arrays.asList(this.lines, this.linesOnShift, this.linesOnCtrl)) {
                TextComponent tabBuilder;
                boolean ctrl;
                boolean shift = list == this.linesOnShift;
                boolean bl2 = ctrl = list == this.linesOnCtrl;
                if (holdDesc.length != 2 || holdCtrl.length != 2) {
                    list.add(0, new TextComponent("Invalid lang formatting!"));
                    continue;
                }
                if (hasControls) {
                    tabBuilder = new TextComponent("");
                    tabBuilder.m_7220_((Component)new TextComponent(holdCtrl[0]).m_130940_(ChatFormatting.DARK_GRAY));
                    tabBuilder.m_7220_((Component)keyCtrl.m_6879_().m_130940_(ctrl ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                    tabBuilder.m_7220_((Component)new TextComponent(holdCtrl[1]).m_130940_(ChatFormatting.DARK_GRAY));
                    list.add(0, tabBuilder);
                }
                if (hasDescription) {
                    tabBuilder = new TextComponent("");
                    tabBuilder.m_7220_((Component)new TextComponent(holdDesc[0]).m_130940_(ChatFormatting.DARK_GRAY));
                    tabBuilder.m_7220_((Component)keyShift.m_6879_().m_130940_(shift ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                    tabBuilder.m_7220_((Component)new TextComponent(holdDesc[1]).m_130940_(ChatFormatting.DARK_GRAY));
                    list.add(0, tabBuilder);
                }
                if (!shift && !ctrl) continue;
                list.add(hasDescription && hasControls ? 2 : 1, new TextComponent(""));
            }
        }
        if (!hasDescription) {
            this.linesOnShift = this.lines;
        }
        if (!hasControls) {
            this.linesOnCtrl = this.lines;
        }
        return this;
    }

    public static String hightlight(String s, Palette palette) {
        return palette.hColor + s + palette.color;
    }

    public static void addStrings(List<Component> infoList, List<Component> textLines) {
        textLines.forEach(s -> ItemDescription.add(infoList, s));
    }

    public static void add(List<Component> infoList, List<Component> textLines) {
        infoList.addAll(textLines);
    }

    public static void add(List<Component> infoList, Component line) {
        infoList.add(line);
    }

    public Palette getPalette() {
        return this.palette;
    }

    public List<Component> addInformation(List<Component> tooltip) {
        if (Screen.m_96638_()) {
            tooltip.addAll(this.linesOnShift);
            return tooltip;
        }
        if (Screen.m_96637_()) {
            tooltip.addAll(this.linesOnCtrl);
            return tooltip;
        }
        tooltip.addAll(this.lines);
        return tooltip;
    }

    public List<Component> getLines() {
        return this.lines;
    }

    public List<Component> getLinesOnCtrl() {
        return this.linesOnCtrl;
    }

    public List<Component> getLinesOnShift() {
        return this.linesOnShift;
    }

    public static enum Palette {
        Blue(ChatFormatting.BLUE, ChatFormatting.AQUA),
        Green(ChatFormatting.DARK_GREEN, ChatFormatting.GREEN),
        Yellow(ChatFormatting.GOLD, ChatFormatting.YELLOW),
        Red(ChatFormatting.DARK_RED, ChatFormatting.RED),
        Purple(ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE),
        Gray(ChatFormatting.DARK_GRAY, ChatFormatting.GRAY);

        public ChatFormatting color;
        public ChatFormatting hColor;

        private Palette(ChatFormatting primary, ChatFormatting highlight) {
            this.color = primary;
            this.hColor = highlight;
        }
    }
}

