/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input;

import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.common.gui.GuiScreenHelper;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.ingredients.TypedIngredient;
import mezz.jei.common.input.ClickedIngredient;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiContainerWrapper
implements IRecipeFocusSource {
    private final RegisteredIngredients registeredIngredients;
    private final GuiScreenHelper guiScreenHelper;

    public GuiContainerWrapper(RegisteredIngredients registeredIngredients, GuiScreenHelper guiScreenHelper) {
        this.registeredIngredients = registeredIngredients;
        this.guiScreenHelper = guiScreenHelper;
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        Screen guiScreen = Minecraft.m_91087_().f_91080_;
        if (!(guiScreen instanceof AbstractContainerScreen)) {
            return Stream.empty();
        }
        AbstractContainerScreen guiContainer = (AbstractContainerScreen)guiScreen;
        return Stream.concat(this.guiScreenHelper.getPluginsIngredientUnderMouse(guiContainer, mouseX, mouseY), this.getSlotIngredientUnderMouse(guiContainer).stream());
    }

    private Optional<IClickedIngredient<?>> getSlotIngredientUnderMouse(AbstractContainerScreen<?> guiContainer) {
        IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
        return Optional.ofNullable(screenHelper.getSlotUnderMouse(guiContainer)).flatMap(slot -> this.getClickedIngredient((Slot)slot, guiContainer));
    }

    private Optional<IClickedIngredient<?>> getClickedIngredient(Slot slot, AbstractContainerScreen<?> guiContainer) {
        ItemStack stack = slot.m_7993_();
        return TypedIngredient.createTyped(this.registeredIngredients, VanillaTypes.ITEM_STACK, stack).map(typedIngredient -> {
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            ImmutableRect2i slotArea = new ImmutableRect2i(screenHelper.getGuiLeft(guiContainer) + slot.f_40220_, screenHelper.getGuiTop(guiContainer) + slot.f_40221_, 16, 16);
            return new ClickedIngredient(typedIngredient, slotArea, false, false);
        });
    }
}

