/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.recipes;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.focus.Focus;
import mezz.jei.common.focus.FocusGroup;
import mezz.jei.common.gui.recipes.layout.RecipeLayout;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.recipes.RecipeCatalystLookup;
import mezz.jei.common.recipes.RecipeCategoriesLookup;
import mezz.jei.common.recipes.RecipeLookup;
import mezz.jei.common.recipes.RecipeManagerInternal;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RecipeManager
implements IRecipeManager {
    private final RecipeManagerInternal internal;
    private final IModIdHelper modIdHelper;
    private final RegisteredIngredients registeredIngredients;
    private final Textures textures;
    private final IIngredientVisibility ingredientVisibility;

    public RecipeManager(RecipeManagerInternal internal, IModIdHelper modIdHelper, RegisteredIngredients registeredIngredients, Textures textures, IIngredientVisibility ingredientVisibility) {
        this.internal = internal;
        this.modIdHelper = modIdHelper;
        this.registeredIngredients = registeredIngredients;
        this.textures = textures;
        this.ingredientVisibility = ingredientVisibility;
    }

    @Override
    @Deprecated(forRemoval=true, since="9.3.0")
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        ErrorUtil.checkNotNull(mode, "mode");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        RecipeIngredientRole role = mode.toRole();
        IIngredientType<V> ingredientType = this.registeredIngredients.getIngredientType(ingredient);
        return Focus.createFromApi(this.registeredIngredients, role, ingredientType, ingredient);
    }

    @Override
    public <R> IRecipeLookup<R> createRecipeLookup(RecipeType<R> recipeType) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        return new RecipeLookup<R>(recipeType, this.internal, this.registeredIngredients);
    }

    @Override
    public IRecipeCategoriesLookup createRecipeCategoryLookup() {
        return new RecipeCategoriesLookup(this.internal, this.registeredIngredients);
    }

    @Override
    public IRecipeCatalystLookup createRecipeCatalystLookup(RecipeType<?> recipeType) {
        return new RecipeCatalystLookup(recipeType, this.internal);
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public <T> void addRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.addRecipes(recipeCategoryUid, List.of(recipe));
    }

    @Override
    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.checkNotNull(recipes, "recipes");
        ErrorUtil.assertMainThread();
        this.internal.addRecipes(recipeType, recipes);
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    @Nullable
    public IRecipeCategory<?> getRecipeCategory(ResourceLocation recipeCategoryUid, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        return this.internal.getRecipeCategoriesStream(List.of(recipeCategoryUid), FocusGroup.EMPTY, includeHidden).findFirst().orElse(null);
    }

    @Deprecated
    public List<RecipeType<?>> getRecipeTypes(Collection<ResourceLocation> recipeCategoryUids) {
        return recipeCategoryUids.stream().map(this.internal::getTypeForRecipeCategoryUid).toList();
    }

    @Deprecated
    public RecipeType<?> getRecipeType(ResourceLocation recipeCategoryUid) {
        return this.internal.getTypeForRecipeCategoryUid(recipeCategoryUid);
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public <V> List<IRecipeCategory<?>> getRecipeCategories(Collection<ResourceLocation> recipeCategoryUids, @Nullable IFocus<V> focus, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategoryUids, "recipeCategoryUids");
        IFocusGroup internalFocus = FocusGroup.createFromNullable(focus, this.registeredIngredients);
        return this.internal.getRecipeCategoriesStream(recipeCategoryUids, internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public <V> List<IRecipeCategory<?>> getRecipeCategories(@Nullable IFocus<V> focus, boolean includeHidden) {
        IFocusGroup internalFocus = FocusGroup.createFromNullable(focus, this.registeredIngredients);
        return this.internal.getRecipeCategoriesStream(List.of(), internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public List<IRecipeCategory<?>> getRecipeCategories(Collection<? extends IFocus<?>> focus, boolean includeHidden) {
        IFocusGroup internalFocus = FocusGroup.create(focus, this.registeredIngredients);
        return this.internal.getRecipeCategoriesStream(List.of(), internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    @Deprecated(forRemoval=true, since="9.3.0")
    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, @Nullable IFocus<V> focus, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        IFocusGroup internalFocus = FocusGroup.createFromNullable(focus, this.registeredIngredients);
        return this.internal.getRecipesStream(recipeCategory.getRecipeType(), internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory, List<? extends IFocus<?>> focuses, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        IFocusGroup internalFocus = FocusGroup.create(focuses, this.registeredIngredients);
        return this.internal.getRecipesStream(recipeCategory.getRecipeType(), internalFocus, includeHidden).collect(Collectors.toList());
    }

    @Override
    @Deprecated(forRemoval=true, since="9.3.0")
    public List<Object> getRecipeCatalysts(IRecipeCategory<?> recipeCategory, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        RecipeType<?> recipeType = recipeCategory.getRecipeType();
        return this.internal.getRecipeCatalystStream(recipeType, includeHidden).map(ITypedIngredient::getIngredient).collect(Collectors.toList());
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public List<ITypedIngredient<?>> getRecipeCatalystsTyped(IRecipeCategory<?> recipeCategory, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        RecipeType<?> recipeType = recipeCategory.getRecipeType();
        return this.internal.getRecipeCatalystStream(recipeType, includeHidden).toList();
    }

    @Override
    public <T> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, @Nullable IFocus<?> focus) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotNull(recipe, "recipe");
        IFocusGroup focusGroup = FocusGroup.createFromNullable(focus, this.registeredIngredients);
        RecipeLayout<T> recipeLayout = RecipeLayout.create(-1, recipeCategory, recipe, focusGroup, this.registeredIngredients, this.ingredientVisibility, this.modIdHelper, 0, 0, this.textures);
        Preconditions.checkNotNull(recipeLayout, (Object)"Recipe layout crashed during creation, see log.");
        return recipeLayout.getLegacyAdapter();
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public <T> void hideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipe(recipeCategoryUid, recipe);
    }

    @Override
    public <T> void hideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        ErrorUtil.checkNotNull(recipes, "recipe");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipes(recipeType, recipes);
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public <T> void unhideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipe(recipe, recipeCategoryUid);
    }

    @Override
    public <T> void unhideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        ErrorUtil.checkNotNull(recipes, "recipe");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipes(recipeType, recipes);
    }

    @Override
    public void hideRecipeCategory(RecipeType<?> recipeType) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipeCategory(recipeType);
    }

    @Override
    public void unhideRecipeCategory(RecipeType<?> recipeType) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipeCategory(recipeType);
    }

    @Override
    @Deprecated
    public void hideRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.hideRecipeCategory(recipeCategoryUid);
    }

    @Override
    @Deprecated
    public void unhideRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.internal.unhideRecipeCategory(recipeCategoryUid);
    }
}

