/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper
implements IPlatformItemStackHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public int getBurnTime(ItemStack itemStack) {
        try {
            return ForgeHooks.getBurnTime((ItemStack)itemStack, null);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is fuel {}.", (Object)itemStackInfo, (Object)e);
            return 0;
        }
    }

    @Override
    public boolean canStack(ItemStack a, ItemStack b) {
        if (a.m_41619_() || !a.m_41656_(b) || a.m_41782_() != b.m_41782_()) {
            return false;
        }
        CompoundTag tag = a.m_41783_();
        if (tag != null && !tag.equals((Object)b.m_41783_())) {
            return false;
        }
        return a.areCapsCompatible((CapabilityProvider)b);
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Item item = stack.m_41720_();
        return item.isBookEnchantable(stack, book);
    }

    @Override
    @Nullable
    public String getCreatorModId(ItemStack stack) {
        Item item = stack.m_41720_();
        return item.getCreatorModId(stack);
    }

    @Override
    public Collection<CreativeModeTab> getCreativeTabs(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item.getCreativeTabs();
    }

    @Override
    public List<Component> getTestTooltip(ItemStack itemStack) {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            ArrayList<TextComponent> tooltip = new ArrayList<TextComponent>();
            tooltip.add(new TextComponent("JEI Tooltip Testing for mod name formatting"));
            ItemTooltipEvent tooltipEvent = ForgeEventFactory.onItemTooltip((ItemStack)itemStack, (Player)player, tooltip, (TooltipFlag)TooltipFlag.Default.NORMAL);
            return tooltipEvent.getToolTip();
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error while Testing for mod name formatting", e);
            return List.of();
        }
    }
}

