/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.CageTrapBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedIronBarsBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPaneBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.util.TriConsumer;

public class CageTrapBlock
extends DisguisableBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.m_61465_((String)"deactivated");

    public CageTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CageTrapBlockEntity) {
            EntityCollisionContext ctx;
            CageTrapBlockEntity be = (CageTrapBlockEntity)blockEntity;
            if (collisionContext instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext).m_193113_() != null) {
                Entity entity = ctx.m_193113_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (be.getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)be, (Entity)player)) {
                        return this.getCorrectShape(state, level, pos, collisionContext, be);
                    }
                }
                if (entity instanceof Mob && !((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    return be.capturesMobs() ? Shapes.m_83040_() : this.getCorrectShape(state, level, pos, collisionContext, be);
                }
                if (entity instanceof ItemEntity) {
                    return this.getCorrectShape(state, level, pos, collisionContext, be);
                }
            }
            return (Boolean)state.m_61143_((Property)DEACTIVATED) != false ? this.getCorrectShape(state, level, pos, collisionContext, be) : Shapes.m_83040_();
        }
        return Shapes.m_83040_();
    }

    private VoxelShape getCorrectShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx, DisguisableBlockEntity disguisableTe) {
        ItemStack moduleStack;
        if (disguisableTe.isModuleEnabled(ModuleType.DISGUISE) && !(moduleStack = disguisableTe.getModule(ModuleType.DISGUISE)).m_41619_() && ((ModuleItem)moduleStack.m_41720_()).getBlockAddon(moduleStack.m_41783_()) != null) {
            return super.m_5939_(state, level, pos, ctx);
        }
        return Shapes.m_83144_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_) {
            CageTrapBlockEntity cageTrap = (CageTrapBlockEntity)level.m_7702_(pos);
            boolean isPlayer = entity instanceof Player;
            if (isPlayer || entity instanceof Mob && cageTrap.capturesMobs()) {
                if (isPlayer && cageTrap.getOwner().isOwner((Player)entity)) {
                    return;
                }
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    return;
                }
                BlockPos topMiddle = pos.m_6630_(4);
                String ownerName = cageTrap.getOwner().getName();
                BlockModifier placer = new BlockModifier(level, new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos), cageTrap.getOwner());
                placer.loop((TriConsumer<Level, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                    if (w.m_46859_((BlockPos)p)) {
                        if (p.equals((Object)topMiddle)) {
                            w.m_46597_((BlockPos)p, ((Block)SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get()).m_49966_());
                        } else {
                            w.m_46597_((BlockPos)p, ((ReinforcedPaneBlock)SCContent.REINFORCED_IRON_BARS.get()).getStateForPlacement((BlockGetter)w, (BlockPos)p));
                        }
                    }
                }));
                placer.loop((TriConsumer<Level, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                    BlockEntity te = w.m_7702_((BlockPos)p);
                    if (te instanceof IOwnable) {
                        IOwnable ownable = (IOwnable)te;
                        ownable.setOwner(o.getUUID(), o.getName());
                    }
                    if (te instanceof ReinforcedIronBarsBlockEntity) {
                        ReinforcedIronBarsBlockEntity ironBarsTe = (ReinforcedIronBarsBlockEntity)te;
                        ironBarsTe.setCanDrop(false);
                    }
                }));
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 3.0f, 1.0f);
                if (isPlayer && PlayerUtils.isPlayerOnline(ownerName)) {
                    PlayerUtils.sendMessageToPlayer(ownerName, (MutableComponent)Utils.localize(((Block)SCContent.CAGE_TRAP.get()).m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:cageTrap.captured", ((Player)entity).m_7755_(), Utils.getFormattedCoordinates(pos)), ChatFormatting.BLACK);
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == SCContent.WIRE_CUTTERS.get()) {
            if (!((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                if (!player.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == Items.f_42451_ && ((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_5594_(null, pos, SoundEvents.f_12524_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DEACTIVATED, WATERLOGGED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CageTrapBlockEntity(pos, state);
    }

    public static class BlockModifier {
        private Level world;
        private BlockPos.MutableBlockPos pos;
        private BlockPos origin;
        private Owner owner;

        public BlockModifier(Level level, BlockPos.MutableBlockPos origin, Owner owner) {
            this.world = level;
            this.pos = origin.m_122184_(-1, 1, -1);
            this.origin = origin.m_7949_();
            this.owner = owner;
        }

        public void loop(TriConsumer<Level, BlockPos.MutableBlockPos, Owner> ifTrue) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        if (x != 1 || z != 1 || y == 3) {
                            ifTrue.accept((Object)this.world, (Object)this.pos, (Object)this.owner);
                        }
                        this.pos.m_122184_(0, 0, 1);
                    }
                    this.pos.m_122184_(1, 0, -3);
                }
                this.pos.m_122184_(-3, 1, 0);
            }
            this.pos.m_122190_((Vec3i)this.origin);
        }
    }
}

