/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.top;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class TOPDataProvider
implements Function<ITheOneProbe, Void> {
    private static final MutableComponent EQUIPPED = new TextComponent("" + ChatFormatting.GRAY).m_7220_((Component)Utils.localize("waila.securitycraft:equipped", new Object[0]));
    private static final MutableComponent ALLOWLIST_MODULE = new TextComponent(ChatFormatting.GRAY + "- ").m_7220_((Component)new TranslatableComponent(ModuleType.ALLOWLIST.getTranslationKey()));
    private static final MutableComponent DISGUISE_MODULE = new TextComponent(ChatFormatting.GRAY + "- ").m_7220_((Component)new TranslatableComponent(ModuleType.DISGUISE.getTranslationKey()));
    private static final MutableComponent SPEED_MODULE = new TextComponent(ChatFormatting.GRAY + "- ").m_7220_((Component)new TranslatableComponent(ModuleType.SPEED.getTranslationKey()));

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, level, blockState, data) -> {
            ItemStack disguisedAs = ItemStack.f_41583_;
            Block patt2993$temp = blockState.m_60734_();
            if (patt2993$temp instanceof DisguisableBlock) {
                DisguisableBlock disguisedBlock = (DisguisableBlock)patt2993$temp;
                disguisedAs = disguisedBlock.getDisguisedStack((BlockGetter)level, data.getPos());
            } else {
                IOverlayDisplay display;
                ItemStack displayStack;
                Block patt3147$temp = blockState.m_60734_();
                if (patt3147$temp instanceof IOverlayDisplay && (displayStack = (display = (IOverlayDisplay)patt3147$temp).getDisplayStack(level, blockState, data.getPos())) != null) {
                    disguisedAs = displayStack;
                }
            }
            if (!disguisedAs.m_41619_()) {
                probeInfo.horizontal().item(disguisedAs).vertical().itemLabel(disguisedAs).text((Component)new TextComponent(ChatFormatting.BLUE + ChatFormatting.ITALIC + ((ModContainer)ModList.get().getModContainerById(disguisedAs.m_41720_().getRegistryName().m_135827_()).get()).getModInfo().getDisplayName()));
                return true;
            }
            return false;
        });
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return new ResourceLocation("securitycraft", "securitycraft");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData data) {
                Nameable nameable;
                IOverlayDisplay display;
                Block block = blockState.m_60734_();
                if (block instanceof IOverlayDisplay && !(display = (IOverlayDisplay)block).shouldShowSCInfo(level, blockState, data.getPos())) {
                    return;
                }
                BlockEntity be = level.m_7702_(data.getPos());
                if (be instanceof IOwnable) {
                    Object team;
                    IOwnable ownable = (IOwnable)be;
                    String ownerName = ownable.getOwner().getName();
                    if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && (team = PlayerUtils.getPlayersTeam(ownerName)) != null) {
                        ownerName = Utils.localize("messages.securitycraft:teamOwner", team.m_7414_() + team.m_83364_().getString() + ChatFormatting.GRAY).getString();
                    }
                    probeInfo.vertical().text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:owner", ownerName).getString()));
                }
                if (be instanceof IModuleInventory) {
                    IOwnable ownable;
                    IModuleInventory inv = (IModuleInventory)be;
                    if (!(be instanceof IOwnable && !(ownable = (IOwnable)be).getOwner().isOwner(player) || inv.getInsertedModules().isEmpty())) {
                        probeInfo.text((Component)EQUIPPED);
                        for (ModuleType module : inv.getInsertedModules()) {
                            probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + "- ").m_7220_((Component)new TranslatableComponent(module.getTranslationKey())));
                        }
                    }
                }
                if (be instanceof IPasswordProtected) {
                    IPasswordProtected passwordProtected = (IPasswordProtected)be;
                    if (!(be instanceof KeycardReaderBlockEntity) && ((IOwnable)be).getOwner().isOwner(player)) {
                        String password = passwordProtected.getPassword();
                        probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:password", password != null && !password.isEmpty() ? password : Utils.localize("waila.securitycraft:password.notSet", new Object[0])).getString()));
                    }
                }
                if (be instanceof Nameable && (nameable = (Nameable)be).m_8077_()) {
                    Component text = nameable.m_7770_();
                    Component name = text == null ? TextComponent.f_131282_ : text;
                    probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:customName", name).getString()));
                }
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, Entity entity, IProbeHitEntityData data) {
                if (entity instanceof Sentry) {
                    PlayerTeam team;
                    Sentry sentry = (Sentry)entity;
                    Sentry.SentryMode mode = sentry.getMode();
                    String ownerName = sentry.getOwner().getName();
                    if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && (team = PlayerUtils.getPlayersTeam(ownerName)) != null) {
                        ownerName = Utils.localize("messages.securitycraft:teamOwner", team.m_7414_() + team.m_83364_().getString() + ChatFormatting.GRAY).getString();
                    }
                    probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + Utils.localize("waila.securitycraft:owner", ownerName).getString()));
                    if (!sentry.getAllowlistModule().m_41619_() || !sentry.getDisguiseModule().m_41619_() || sentry.hasSpeedModule()) {
                        probeInfo.text((Component)EQUIPPED);
                        if (!sentry.getAllowlistModule().m_41619_()) {
                            probeInfo.text((Component)ALLOWLIST_MODULE);
                        }
                        if (!sentry.getDisguiseModule().m_41619_()) {
                            probeInfo.text((Component)DISGUISE_MODULE);
                        }
                        if (sentry.hasSpeedModule()) {
                            probeInfo.text((Component)SPEED_MODULE);
                        }
                    }
                    TranslatableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
                    if (mode != Sentry.SentryMode.IDLE) {
                        modeDescription.m_130946_("- ").m_7220_((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
                    }
                    probeInfo.text((Component)new TextComponent(ChatFormatting.GRAY + modeDescription.getString()));
                }
            }
        });
        return null;
    }
}

