/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class RemoteControlMine {
    private int x;
    private int y;
    private int z;
    private String state;

    public RemoteControlMine() {
    }

    public RemoteControlMine(int x, int y, int z, String state) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = state;
    }

    public static void encode(RemoteControlMine message, FriendlyByteBuf buf) {
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
        buf.m_130070_(message.state);
    }

    public static RemoteControlMine decode(FriendlyByteBuf buf) {
        RemoteControlMine message = new RemoteControlMine();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        message.state = buf.m_130136_(0x1FFFFFFF);
        return message;
    }

    public static void onMessage(RemoteControlMine message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.f_19853_;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            BlockState state = level.m_8055_(pos);
            Block patt1578$temp = state.m_60734_();
            if (patt1578$temp instanceof IExplosive) {
                IOwnable be;
                IExplosive explosive = (IExplosive)patt1578$temp;
                BlockEntity patt1648$temp = level.m_7702_(pos);
                if (patt1648$temp instanceof IOwnable && (be = (IOwnable)patt1648$temp).getOwner().isOwner((Player)player)) {
                    if (message.state.equalsIgnoreCase("activate")) {
                        explosive.activateMine(level, pos);
                    } else if (message.state.equalsIgnoreCase("defuse")) {
                        explosive.defuseMine(level, pos);
                    } else if (message.state.equalsIgnoreCase("detonate")) {
                        explosive.explode(level, pos);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

