/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.GuiUtils;

public class CollapsibleTextList
extends Button {
    private static final TextComponent PLUS = new TextComponent("+ ");
    private static final TextComponent MINUS = new TextComponent("- ");
    private final int threeDotsWidth;
    private final int heightOpen;
    private final int textCutoff;
    private final Component originalDisplayString;
    private final List<? extends Component> textLines;
    private final List<Long> splitTextLineCount;
    private final BiPredicate<Integer, Integer> extraHoverCheck;
    private boolean open;
    private boolean isMessageTooLong;
    private int initialY;

    public CollapsibleTextList(int xPos, int yPos, int width, Component displayString, List<? extends Component> textLines, Button.OnPress onPress, BiPredicate<Integer, Integer> extraHoverCheck) {
        super(xPos, yPos, width, 12, displayString, onPress);
        this.threeDotsWidth = Minecraft.m_91087_().f_91062_.m_92895_("...");
        this.open = true;
        this.isMessageTooLong = false;
        this.initialY = -1;
        this.originalDisplayString = displayString;
        this.switchOpenStatus();
        this.textCutoff = width - 5;
        ImmutableList.Builder splitTextLineCountBuilder = new ImmutableList.Builder();
        Font font = Minecraft.m_91087_().f_91062_;
        int amountOfLines = 0;
        for (Component component : textLines) {
            long count = font.m_92865_().m_92414_((FormattedText)component, this.textCutoff, component.m_7383_()).size();
            amountOfLines = (int)((long)amountOfLines + count);
            splitTextLineCountBuilder.add((Object)count);
        }
        this.textLines = textLines;
        this.splitTextLineCount = splitTextLineCountBuilder.build();
        Objects.requireNonNull(font);
        this.heightOpen = this.f_93619_ + amountOfLines * 9 + textLines.size() * 3;
        this.extraHoverCheck = extraHoverCheck;
    }

    public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        this.f_93622_ &= this.extraHoverCheck.test(mouseX, mouseY);
        Font font = Minecraft.m_91087_().f_91062_;
        int v = this.m_7202_(this.m_198029_());
        int heightOffset = (this.f_93619_ - 8) / 2;
        GuiUtils.drawContinuousTexturedBox((PoseStack)pose, (ResourceLocation)f_93617_, (int)this.f_93620_, (int)this.f_93621_, (int)0, (int)(46 + v * 20), (int)this.f_93618_, (int)this.f_93619_, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.m_93252_());
        CollapsibleTextList.m_93215_((PoseStack)pose, (Font)font, (Component)this.m_6035_(), (int)(this.f_93620_ + font.m_92852_((FormattedText)this.m_6035_()) / 2 + 3), (int)(this.f_93621_ + heightOffset), (int)this.getFGColor());
        if (this.open) {
            int renderedLines = 0;
            Matrix4f m4f = pose.m_85850_().m_85861_();
            GuiUtils.drawGradientRect((Matrix4f)m4f, (int)0, (int)this.f_93620_, (int)(this.f_93621_ + this.f_93619_), (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.heightOpen), (int)-1072689136, (int)-804253680);
            for (int i = 0; i < this.textLines.size(); ++i) {
                Objects.requireNonNull(font);
                int textY = this.f_93621_ + 2 + this.f_93619_ + renderedLines * 9 + i * 12;
                if (i > 0) {
                    GuiUtils.drawGradientRect((Matrix4f)m4f, (int)this.m_93252_(), (int)(this.f_93620_ + 1), (int)(textY - 3), (int)(this.f_93620_ + this.f_93618_ - 2), (int)(textY - 2), (int)-1432313696, (int)-1432313696);
                }
                font.m_92857_((FormattedText)this.textLines.get(i), this.f_93620_ + 2, textY, this.textCutoff, this.getFGColor());
                renderedLines = (int)((long)renderedLines + (this.splitTextLineCount.get(i) - 1L));
            }
        }
    }

    public void renderLongMessageTooltip(PoseStack pose) {
        Screen currentScreen;
        if (this.isMessageTooLong && this.m_198029_() && (currentScreen = Minecraft.m_91087_().f_91080_) != null) {
            currentScreen.m_96602_(pose, this.originalDisplayString, this.f_93620_ + 1, this.f_93621_ + this.f_93619_ + 2);
        }
    }

    public void m_93666_(Component message) {
        int cutoff;
        Font font = Minecraft.m_91087_().f_91062_;
        int stringWidth = font.m_92852_((FormattedText)message);
        if (stringWidth > (cutoff = this.f_93618_ - 6) && stringWidth > this.threeDotsWidth) {
            this.isMessageTooLong = true;
            message = new TextComponent(font.m_92854_((FormattedText)message, cutoff - this.threeDotsWidth).getString() + "...");
        }
        super.m_93666_(message);
    }

    public int m_93694_() {
        return this.open ? this.heightOpen : this.f_93619_;
    }

    public void m_5691_() {
        this.switchOpenStatus();
        super.m_5691_();
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.m_5953_(mouseX, mouseY);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.extraHoverCheck.test((int)mouseX, (int)mouseY) && super.m_5953_(mouseX, mouseY);
    }

    public void setY(int y) {
        if (this.initialY == -1) {
            this.initialY = y;
        }
        this.f_93621_ = y;
    }

    public void switchOpenStatus() {
        this.open = !this.open;
        this.m_93666_((Component)(this.open ? MINUS : PLUS).m_6881_().m_7220_(this.originalDisplayString));
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getInitialY() {
        return this.initialY;
    }
}

