/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedHalfStairsModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean right;

    public FramedHalfStairsModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        this.right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad copy;
        Direction vertCut;
        Direction face = quad.m_111306_();
        Direction direction = vertCut = this.right ? this.dir.m_122428_() : this.dir.m_122427_();
        if (face == this.dir) {
            BakedQuad copy2 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(copy2, vertCut, 0.5f)) {
                quadMap.get(face).add(copy2);
            }
        } else if (face == this.dir.m_122424_()) {
            BakedQuad copy3 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(copy3, vertCut, 0.5f)) {
                BakedQuad copyTwo = ModelUtils.duplicateQuad(copy3);
                if (BakedQuadTransformer.createHorizontalSideQuad(copyTwo, !this.top, 0.5f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(copyTwo, 0.5f);
                    quadMap.get(null).add(copyTwo);
                }
                if (BakedQuadTransformer.createHorizontalSideQuad(copy3, this.top, 0.5f)) {
                    quadMap.get(face).add(copy3);
                }
            }
        } else if (!Utils.isY(face) && face.m_122434_() != this.dir.m_122434_()) {
            BakedQuad copy4 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(copy4, this.dir.m_122424_(), 0.5f)) {
                if (face == vertCut) {
                    BakedQuadTransformer.setQuadPosInFacingDir(copy4, 0.5f);
                    quadMap.get(null).add(copy4);
                } else {
                    quadMap.get(face).add(copy4);
                }
            }
            if (BakedQuadTransformer.createVerticalSideQuad(copy4 = ModelUtils.duplicateQuad(quad), this.dir, 0.5f) && BakedQuadTransformer.createHorizontalSideQuad(copy4, this.top, 0.5f)) {
                if (face == vertCut) {
                    BakedQuadTransformer.setQuadPosInFacingDir(copy4, 0.5f);
                    quadMap.get(null).add(copy4);
                } else {
                    quadMap.get(face).add(copy4);
                }
            }
        } else if (face == Direction.UP && this.top || face == Direction.DOWN && !this.top) {
            BakedQuad copy5 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(copy5, vertCut, 0.5f)) {
                quadMap.get(face).add(copy5);
            }
        } else if ((face == Direction.UP && !this.top || face == Direction.DOWN && this.top) && BakedQuadTransformer.createTopBottomQuad(copy = ModelUtils.duplicateQuad(quad), vertCut, 0.5f)) {
            BakedQuad copyTwo = ModelUtils.duplicateQuad(copy);
            if (BakedQuadTransformer.createTopBottomQuad(copyTwo, this.dir, 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(copyTwo, 0.5f);
                quadMap.get(null).add(copyTwo);
            }
            if (BakedQuadTransformer.createTopBottomQuad(copy, this.dir.m_122424_(), 0.5f)) {
                quadMap.get(face).add(copy);
            }
        }
    }
}

