/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.item.chisel.IChiselItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.block.ChiseledPrinterBlock;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.container.ChiseledPrinterContainer;
import mod.chiselsandbits.platforms.core.item.IItemComparisonHelper;
import mod.chiselsandbits.registrars.ModBlockEntityTypes;
import mod.chiselsandbits.utils.container.SimpleContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledPrinterBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private final MutableObject<ItemStack> currentRealisedWorkingStack = new MutableObject((Object)ItemStack.f_41583_);
    private final Optional<SimpleContainer> tool_handler = Optional.of(new SimpleContainer(1));
    private final Optional<SimpleContainer> pattern_handler = Optional.of(new SimpleContainer(1));
    private final Optional<SimpleContainer> result_handler = Optional.of(new SimpleContainer(1));
    private int progress = 0;
    protected final ContainerData stationData = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return ChiseledPrinterBlockEntity.this.progress;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                ChiseledPrinterBlockEntity.this.progress = value;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private long lastTickTime = 0L;

    public ChiseledPrinterBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CHISELED_PRINTER.get(), pos, state);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.tool_handler.ifPresent(h -> h.deserializeNBT(nbt.m_128469_("tool")));
        this.pattern_handler.ifPresent(h -> h.deserializeNBT(nbt.m_128469_("pattern")));
        this.result_handler.ifPresent(h -> h.deserializeNBT(nbt.m_128469_("result")));
        this.progress = nbt.m_128451_("progress");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        this.tool_handler.ifPresent(h -> compound.m_128365_("tool", (Tag)h.serializeNBT()));
        this.pattern_handler.ifPresent(h -> compound.m_128365_("pattern", (Tag)h.serializeNBT()));
        this.result_handler.ifPresent(h -> compound.m_128365_("result", (Tag)h.serializeNBT()));
        compound.m_128405_("progress", this.progress);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void tick() {
        if (this.m_58904_() == null || this.lastTickTime == this.m_58904_().m_46467_() || this.m_58904_().m_5776_()) {
            return;
        }
        this.lastTickTime = this.m_58904_().m_46467_();
        if (this.couldWork()) {
            if (this.canWork()) {
                ++this.progress;
                if (this.progress >= 100) {
                    this.result_handler.ifPresent(h -> {
                        if (h.m_8020_(0).m_41619_()) {
                            h.m_6836_(0, this.realisePattern(true));
                            return;
                        }
                        h.m_8020_(0).m_41764_(h.m_8020_(0).m_41613_() + this.realisePattern(true).m_41613_());
                    });
                    this.currentRealisedWorkingStack.setValue((Object)ItemStack.f_41583_);
                    this.progress = 0;
                    this.damageChisel();
                }
                this.m_6596_();
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.m_6596_();
        }
    }

    public boolean hasPatternStack() {
        return !this.getPatternStack().m_41619_();
    }

    public boolean hasToolStack() {
        return !this.getToolStack().m_41619_();
    }

    public boolean hasRealisedStack() {
        return !this.getRealisedStack().m_41619_();
    }

    public boolean hasOutputStack() {
        return !this.getOutputStack().m_41619_();
    }

    public boolean canMergeOutputs() {
        if (!this.hasOutputStack()) {
            return true;
        }
        if (!this.hasRealisedStack()) {
            return false;
        }
        return IItemComparisonHelper.getInstance().canItemStacksStack(this.getOutputStack(), this.getRealisedStack()) && this.getOutputStack().m_41613_() + this.getRealisedStack().m_41613_() <= this.getOutputStack().m_41741_();
    }

    public boolean canWork() {
        return this.hasPatternStack() && this.hasToolStack() && this.canMergeOutputs() && !this.getRealisedStack().m_41619_();
    }

    public boolean couldWork() {
        return this.hasPatternStack() && this.hasToolStack();
    }

    public ItemStack getRealisedStack() {
        ItemStack realisedStack = (ItemStack)this.currentRealisedWorkingStack.getValue();
        if (realisedStack.m_41619_()) {
            realisedStack = this.realisePattern(false);
            this.currentRealisedWorkingStack.setValue((Object)realisedStack);
        }
        return realisedStack;
    }

    private ItemStack realisePattern(boolean consumeResources) {
        BlockInformation thirdState;
        if (!this.hasPatternStack()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.getPatternStack();
        Item item = stack.m_41720_();
        if (!(item instanceof IPatternItem)) {
            return ItemStack.f_41583_;
        }
        IPatternItem patternItem = (IPatternItem)item;
        IMultiStateItemStack realisedPattern = patternItem.createItemStack(stack);
        if (realisedPattern.getStatistics().isEmpty()) {
            return ItemStack.f_41583_;
        }
        BlockInformation firstState = this.getPrimaryBlockState() == null ? BlockInformation.AIR : this.getPrimaryBlockState();
        BlockInformation secondState = this.getSecondaryBlockState() == null ? BlockInformation.AIR : this.getSecondaryBlockState();
        BlockInformation blockInformation = thirdState = this.getTertiaryBlockState() == null ? BlockInformation.AIR : this.getTertiaryBlockState();
        if (firstState.isAir() && secondState.isAir() && thirdState.isAir()) {
            return ItemStack.f_41583_;
        }
        if (!IEligibilityManager.getInstance().canBeChiseled(firstState.getBlockState()) && !firstState.isAir() || !IEligibilityManager.getInstance().canBeChiseled(secondState.getBlockState()) && !secondState.isAir() || !IEligibilityManager.getInstance().canBeChiseled(thirdState.getBlockState()) && !thirdState.isAir()) {
            return ItemStack.f_41583_;
        }
        IMultiStateSnapshot modifiableSnapshot = realisedPattern.createSnapshot();
        modifiableSnapshot.mutableStream().filter(e -> !(e.getBlockInformation().equals(firstState) && !firstState.equals(BlockInformation.AIR) || e.getBlockInformation().equals(secondState) && !secondState.equals(BlockInformation.AIR) || e.getBlockInformation().equals(thirdState) && !thirdState.equals(BlockInformation.AIR) || e.getBlockInformation().equals(BlockInformation.AIR))).forEach(IMutableStateEntryInfo::clear);
        if (modifiableSnapshot.getStatics().getStateCounts().size() == 1 && modifiableSnapshot.getStatics().getStateCounts().containsKey(BlockInformation.AIR)) {
            return ItemStack.f_41583_;
        }
        if (modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0) == 0 && modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0) == 0 && modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0) == 0) {
            return ItemStack.f_41583_;
        }
        if (modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0) > this.getAvailablePrimaryBlockState() && !firstState.equals(BlockInformation.AIR) || modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0) > this.getAvailableSecondaryBlockState() && !secondState.equals(BlockInformation.AIR) || modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0) > this.getAvailableTertiaryBlockState() && !thirdState.equals(BlockInformation.AIR)) {
            return ItemStack.f_41583_;
        }
        if (consumeResources) {
            this.drainPrimaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0));
            this.drainSecondaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0));
            this.drainTertiaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0));
        }
        return modifiableSnapshot.toItemStack().toBlockStack();
    }

    private void damageChisel() {
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            this.getToolStack().m_41629_(1, this.m_58904_().m_5822_(), null);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new ChiseledPrinterContainer(containerId, playerInventory, this.getPatternHandler(), this.getToolHandler(), this.getResultHandler(), this.stationData);
    }

    public SimpleContainer getPatternHandler() {
        return this.pattern_handler.orElseThrow(() -> new IllegalStateException("Missing empty handler."));
    }

    public SimpleContainer getToolHandler() {
        return this.tool_handler.orElseThrow(() -> new IllegalStateException("Missing tool handler."));
    }

    public SimpleContainer getResultHandler() {
        return this.result_handler.orElseThrow(() -> new IllegalStateException("Missing result handler."));
    }

    @NotNull
    public Component m_5446_() {
        return LocalStrings.ChiselStationName.getText();
    }

    public int getAvailablePrimaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122427_();
        return this.getStorageContents(targetedFacing);
    }

    public int getAvailableSecondaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122427_().m_122427_();
        return this.getStorageContents(targetedFacing);
    }

    public int getAvailableTertiaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122428_();
        return this.getStorageContents(targetedFacing);
    }

    private int getStorageContents(Direction targetedFacing) {
        BlockEntity targetedTileEntity = Objects.requireNonNull(this.m_58904_()).m_7702_(this.m_58899_().m_142300_(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            return storage.getBits();
        }
        return 0;
    }

    public BlockInformation getPrimaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122427_();
        return this.getStorage(targetedFacing);
    }

    public BlockInformation getSecondaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122427_().m_122427_();
        return this.getStorage(targetedFacing);
    }

    public BlockInformation getTertiaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122428_();
        return this.getStorage(targetedFacing);
    }

    private BlockInformation getStorage(Direction targetedFacing) {
        BlockEntity targetedTileEntity = Objects.requireNonNull(this.m_58904_()).m_7702_(this.m_58899_().m_142300_(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            return storage.getContainedBlockInformation();
        }
        return BlockInformation.AIR;
    }

    public void drainPrimaryStorage(int amount) {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122427_();
        this.drainStorage(amount, targetedFacing);
    }

    public void drainSecondaryStorage(int amount) {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122427_().m_122427_();
        this.drainStorage(amount, targetedFacing);
    }

    public void drainTertiaryStorage(int amount) {
        Direction facing = (Direction)Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_()).m_61143_((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.m_122428_();
        this.drainStorage(amount, targetedFacing);
    }

    private void drainStorage(int amount, Direction targetedFacing) {
        BlockEntity targetedTileEntity = Objects.requireNonNull(this.m_58904_()).m_7702_(this.m_58899_().m_142300_(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            storage.extractBits(amount);
        }
    }

    public void dropInventoryItems(Level worldIn, BlockPos pos) {
        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.getToolStack());
        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.getOutputStack());
        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.getPatternStack());
    }

    public ItemStack getToolStack() {
        return this.tool_handler.map(h -> h.m_8020_(0)).orElse(ItemStack.f_41583_);
    }

    public ItemStack getOutputStack() {
        return this.result_handler.map(h -> h.m_8020_(0)).orElse(ItemStack.f_41583_);
    }

    public ItemStack getPatternStack() {
        return this.pattern_handler.map(h -> h.m_8020_(0)).orElse(ItemStack.f_41583_);
    }

    public int @NotNull [] m_7071_(@NotNull Direction direction) {
        int[] nArray;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 2;
                break;
            }
            case UP: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
                break;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 0;
            }
        }
        return nArray;
    }

    public boolean m_7155_(int index, ItemStack itemStack, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> false;
            case Direction.UP -> itemStack.m_41720_() instanceof IChiselItem;
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> itemStack.m_41720_() instanceof IMultiUsePatternItem;
        };
    }

    public boolean m_7157_(int index, ItemStack itemStack, @NotNull Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> true;
            case Direction.UP -> itemStack.m_41720_() instanceof IChiselItem;
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> itemStack.m_41720_() instanceof IMultiUsePatternItem;
        };
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        return this.getPatternHandler().m_7983_() && this.getToolHandler().m_7983_() && this.getResultHandler().m_7983_();
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return switch (index) {
            case 0 -> this.getPatternStack();
            case 1 -> this.getToolStack();
            case 2 -> this.getOutputStack();
            default -> ItemStack.f_41583_;
        };
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return switch (index) {
            case 0 -> this.getPatternHandler().m_7407_(0, count);
            case 1 -> this.getToolHandler().m_7407_(0, count);
            case 2 -> this.getResultHandler().m_7407_(0, count);
            default -> ItemStack.f_41583_;
        };
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return switch (index) {
            case 0 -> this.getPatternHandler().m_8016_(0);
            case 1 -> this.getToolHandler().m_8016_(0);
            case 2 -> this.getResultHandler().m_8016_(0);
            default -> ItemStack.f_41583_;
        };
    }

    public void m_6836_(int index, @NotNull ItemStack itemStack) {
        switch (index) {
            case 0: {
                this.getPatternHandler().m_6836_(0, itemStack);
                break;
            }
            case 1: {
                this.getToolHandler().m_6836_(0, itemStack);
                break;
            }
            case 2: {
                this.getResultHandler().m_6836_(0, itemStack);
            }
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.getPatternHandler().m_6211_();
        this.getToolHandler().m_6211_();
        this.getResultHandler().m_6211_();
    }
}

