/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.mutator;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessorWithVoxelShape;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.multistate.mutator.ChiselAdaptingWorldMutator;
import mod.chiselsandbits.multistate.snapshot.MultiBlockMultiStateSnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WorldWrappingMutator
implements IWorldAreaMutator,
IAreaAccessorWithVoxelShape {
    private final LevelAccessor world;
    private final Vec3 startPoint;
    private final Vec3 endPoint;

    public WorldWrappingMutator(LevelAccessor world, Vec3 startPoint, Vec3 endPoint) {
        this.world = world;
        this.startPoint = new Vec3(Math.min(startPoint.m_7096_(), endPoint.m_7096_()), Math.min(startPoint.m_7098_(), endPoint.m_7098_()), Math.min(startPoint.m_7094_(), endPoint.m_7094_()));
        this.endPoint = new Vec3(Math.max(startPoint.m_7096_(), endPoint.m_7096_()), Math.max(startPoint.m_7098_(), endPoint.m_7098_()), Math.max(startPoint.m_7094_(), endPoint.m_7094_()));
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        BlockPos endBlockPos;
        BlockPos startBlockPos = new BlockPos(this.getInWorldStartPoint());
        Stream<BlockPos> positionStream = startBlockPos.equals((Object)(endBlockPos = new BlockPos(this.getInWorldEndPoint()))) ? Stream.of(startBlockPos) : BlockPosStreamProvider.getForRange(startBlockPos.m_123341_(), startBlockPos.m_123342_(), startBlockPos.m_123343_(), endBlockPos.m_123341_(), endBlockPos.m_123342_(), endBlockPos.m_123343_());
        Collection identifiers = positionStream.map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos)).map(ChiselAdaptingWorldMutator::createNewShapeIdentifier).collect(Collectors.toList());
        return new Identifier(identifiers, this.startPoint, this.endPoint);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return this.inWorldMutableStream().map(IStateEntryInfo.class::cast);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vec3 inAreaTarget) {
        if (!this.isInside(inAreaTarget)) {
            return Optional.empty();
        }
        BlockPos exactPosition = new BlockPos(inAreaTarget);
        Vec3 exactInBlockOffset = inAreaTarget.m_82492_((double)exactPosition.m_123341_(), (double)exactPosition.m_123342_(), (double)exactPosition.m_123343_());
        return this.getInBlockTarget(exactPosition, exactInBlockOffset);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!this.isInside(inAreaBlockPosOffset, inBlockTarget)) {
            return Optional.empty();
        }
        return new ChiselAdaptingWorldMutator(this.getWorld(), inAreaBlockPosOffset).getInAreaTarget(inBlockTarget);
    }

    @Override
    public boolean isInside(Vec3 inAreaTarget) {
        return this.getInWorldBoundingBox().m_82390_(inAreaTarget);
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        return this.isInside(Vec3.m_82528_((Vec3i)inAreaBlockPosOffset).m_82549_(inBlockTarget));
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        BlockPos endBlockPos;
        BlockPos startBlockPos = new BlockPos(this.getInWorldStartPoint());
        Stream<BlockPos> positionStream = startBlockPos.equals((Object)(endBlockPos = new BlockPos(this.getInWorldEndPoint()))) ? Stream.of(startBlockPos) : BlockPosStreamProvider.getForRange(startBlockPos.m_123341_(), startBlockPos.m_123342_(), startBlockPos.m_123343_(), endBlockPos.m_123341_(), endBlockPos.m_123342_(), endBlockPos.m_123343_());
        Map<BlockPos, IMultiStateSnapshot> snapshots = positionStream.collect(Collectors.toMap(Function.identity(), blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos).createSnapshot()));
        return new MultiBlockMultiStateSnapshot(snapshots, this.getInWorldStartPoint(), this.getInWorldEndPoint());
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(this.getInWorldStartPoint().m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.getInWorldEndPoint().m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())).map(positionMutator::mutate).map(position -> Vec3.m_82528_((Vec3i)position).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())).map(position -> {
            BlockPos blockPos = new BlockPos(position);
            Vec3 inBlockOffset = position.m_82546_(Vec3.m_82528_((Vec3i)blockPos));
            return this.getInBlockTarget(blockPos, inBlockOffset);
        }).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(this.getInWorldStartPoint().m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.getInWorldEndPoint().m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), blockPos -> {
            Vec3i target = positionMutator.mutate((Vec3i)blockPos);
            Vec3 scaledTarget = Vec3.m_82528_((Vec3i)target).m_82559_(StateEntrySize.current().getSizePerBitScalingVector());
            BlockPos position = new BlockPos((Vec3i)blockPos);
            Vec3 inBlockOffset = scaledTarget.m_82546_(Vec3.m_82528_((Vec3i)position));
            Optional<IStateEntryInfo> targetCandidate = this.getInBlockTarget(position, inBlockOffset);
            targetCandidate.ifPresent(consumer);
        });
    }

    @Override
    public LevelAccessor getWorld() {
        return this.world;
    }

    @Override
    public Vec3 getInWorldStartPoint() {
        return this.startPoint;
    }

    @Override
    public Vec3 getInWorldEndPoint() {
        return this.endPoint;
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return this.inWorldMutableStream().map(IMutableStateEntryInfo.class::cast);
    }

    @Override
    public void setInAreaTarget(BlockInformation blockInformation, Vec3 inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0) {
            throw new IllegalArgumentException(String.format("The in area target can not have a negative component: %s", inAreaTarget));
        }
        Vec3 actualTarget = this.getInWorldStartPoint().m_82549_(inAreaTarget);
        if (actualTarget.m_7096_() >= this.getInWorldEndPoint().m_7096_() || actualTarget.m_7098_() >= this.getInWorldEndPoint().m_7098_() || actualTarget.m_7094_() >= this.getInWorldEndPoint().m_7094_()) {
            throw new IllegalArgumentException(String.format("The in area target is larger then the allowed size:%s", inAreaTarget));
        }
        BlockPos blockPosTarget = new BlockPos(actualTarget);
        Vec3 inBlockPosTarget = actualTarget.m_82546_(Vec3.m_82528_((Vec3i)blockPosTarget));
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), blockPosTarget);
        innerMutator.setInAreaTarget(blockInformation, inBlockPosTarget);
    }

    @Override
    public void setInBlockTarget(BlockInformation blockInformation, BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) throws SpaceOccupiedException {
        BlockPos startPos = new BlockPos(this.getInWorldStartPoint());
        BlockPos targetPos = startPos.m_141952_((Vec3i)inAreaBlockPosOffset);
        Vec3 target = Vec3.m_82528_((Vec3i)targetPos).m_82549_(inBlockTarget);
        if (target.m_7096_() < this.getInWorldStartPoint().m_7096_() || target.m_7098_() < this.getInWorldStartPoint().m_7098_() || target.m_7094_() < this.getInWorldStartPoint().m_7094_()) {
            throw new IllegalArgumentException(String.format("The target can not be smaller then the start point: %s", target));
        }
        if (target.m_7096_() >= this.getInWorldEndPoint().m_7096_() || target.m_7098_() >= this.getInWorldEndPoint().m_7098_() || target.m_7094_() >= this.getInWorldEndPoint().m_7094_()) {
            throw new IllegalArgumentException(String.format("The target can not be greater then the start point: %s", target));
        }
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), targetPos);
        innerMutator.setInBlockTarget(blockInformation, BlockPos.f_121853_, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vec3 inAreaTarget) {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0) {
            throw new IllegalArgumentException(String.format("The in area target can not have a negative component: %s", inAreaTarget));
        }
        Vec3 actualTarget = this.getInWorldStartPoint().m_82549_(inAreaTarget);
        if (actualTarget.m_7096_() >= this.getInWorldEndPoint().m_7096_() || actualTarget.m_7098_() >= this.getInWorldEndPoint().m_7098_() || actualTarget.m_7094_() >= this.getInWorldEndPoint().m_7094_()) {
            throw new IllegalArgumentException(String.format("The in area target is larger then the allowed size:%s", inAreaTarget));
        }
        BlockPos blockPosTarget = new BlockPos(actualTarget);
        Vec3 inBlockPosTarget = actualTarget.m_82546_(Vec3.m_82528_((Vec3i)blockPosTarget));
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), blockPosTarget);
        innerMutator.clearInAreaTarget(inBlockPosTarget);
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        BlockPos startPos = new BlockPos(this.getInWorldStartPoint());
        BlockPos targetPos = startPos.m_141952_((Vec3i)inAreaBlockPosOffset);
        Vec3 target = Vec3.m_82528_((Vec3i)targetPos).m_82549_(inBlockTarget);
        if (target.m_7096_() < this.getInWorldStartPoint().m_7096_() || target.m_7098_() < this.getInWorldStartPoint().m_7098_() || target.m_7094_() < this.getInWorldStartPoint().m_7094_()) {
            throw new IllegalArgumentException(String.format("The target can not be smaller then the start point: %s", target));
        }
        if (target.m_7096_() >= this.getInWorldEndPoint().m_7096_() || target.m_7098_() >= this.getInWorldEndPoint().m_7098_() || target.m_7094_() >= this.getInWorldEndPoint().m_7094_()) {
            throw new IllegalArgumentException(String.format("The target can not be greater then the start point: %s", target));
        }
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), targetPos);
        innerMutator.clearInBlockTarget(BlockPos.f_121853_, inBlockTarget);
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        return BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).flatMap(blockPos -> this.positionBasedInWorldMutableStream((BlockPos)blockPos).filter(entry -> this.getInWorldBoundingBox().m_82381_(entry.getInWorldBoundingBox()) || entry.getInWorldBoundingBox().m_82381_(this.getInWorldBoundingBox())));
    }

    private Stream<IInWorldMutableStateEntryInfo> positionBasedInWorldMutableStream(BlockPos position) {
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), position);
        return innerMutator.inWorldMutableStream();
    }

    @Override
    public IBatchMutation batch() {
        return new BatchMutationLock(BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos)).map(ChiselAdaptingWorldMutator::batch).collect(Collectors.toList()));
    }

    @Override
    public IBatchMutation batch(IChangeTracker changeTracker) {
        Map<BlockPos, IMultiStateSnapshot> before = BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos)).collect(Collectors.toMap(ChiselAdaptingWorldMutator::getPos, ChiselAdaptingWorldMutator::createSnapshot));
        IBatchMutation innerMutation = this.batch();
        return () -> {
            Map<BlockPos, IMultiStateSnapshot> after = BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos)).collect(Collectors.toMap(ChiselAdaptingWorldMutator::getPos, ChiselAdaptingWorldMutator::createSnapshot));
            innerMutation.close();
            changeTracker.onBlocksUpdated(before, after);
        };
    }

    @Override
    public VoxelShape provideShape(CollisionType type, BlockPos offset, boolean simplify) {
        VoxelShape areaShape = Shapes.m_83064_((AABB)this.getInWorldBoundingBox().m_82338_(VectorUtils.invert(new BlockPos(this.getInWorldStartPoint()))).m_82338_(offset));
        VoxelShape containedShape = BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos)).map(a -> IVoxelShapeManager.getInstance().get((IAreaAccessor)a, new BlockPos(a.getInWorldStartPoint()).m_141952_((Vec3i)VectorUtils.invert(new BlockPos(this.getInWorldStartPoint()))).m_141952_((Vec3i)offset), type, simplify)).reduce(Shapes.m_83040_(), (voxelShape, bbShape) -> Shapes.m_83148_((VoxelShape)voxelShape, (VoxelShape)bbShape, (BooleanOp)BooleanOp.f_82695_), (voxelShape, voxelShape2) -> Shapes.m_83148_((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (BooleanOp)BooleanOp.f_82695_));
        VoxelShape requestedShape = Shapes.m_83148_((VoxelShape)areaShape, (VoxelShape)containedShape, (BooleanOp)BooleanOp.f_82689_);
        return simplify ? requestedShape.m_83296_() : requestedShape;
    }

    public String toString() {
        return "WorldWrappingMutator{world=" + this.world + ", startPoint=" + this.startPoint + ", endPoint=" + this.endPoint + "}";
    }

    @Override
    @NotNull
    public AABB getBoundingBox() {
        return new AABB(this.startPoint, this.endPoint);
    }

    private static final class Identifier
    implements IAreaShapeIdentifier {
        private final Collection<IAreaShapeIdentifier> inners;
        private final Vec3 startPoint;
        private final Vec3 endPoint;

        public Identifier(Collection<IAreaShapeIdentifier> innerSnapshots, Vec3 startPoint, Vec3 endPoint) {
            this.inners = innerSnapshots;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.inners.equals(that.inners) && this.startPoint.equals((Object)that.startPoint) && this.endPoint.equals((Object)that.endPoint);
        }

        public int hashCode() {
            return Objects.hash(this.inners, this.startPoint, this.endPoint);
        }
    }

    private static final class BatchMutationLock
    implements IBatchMutation {
        private final Iterable<IBatchMutation> innerLocks;

        private BatchMutationLock(Iterable<IBatchMutation> innerLocks) {
            this.innerLocks = innerLocks;
        }

        @Override
        public void close() {
            for (IBatchMutation innerLock : this.innerLocks) {
                innerLock.close();
            }
        }
    }
}

