/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.permissions;

import com.google.common.collect.Maps;
import java.util.Map;
import mod.chiselsandbits.api.multistate.accessor.world.IWorldAreaAccessor;
import mod.chiselsandbits.api.permissions.ICheckerRegistration;
import mod.chiselsandbits.api.permissions.IPermissionChecker;
import mod.chiselsandbits.api.permissions.IPermissionHandler;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public final class PermissionHandler
implements IPermissionHandler {
    private static final PermissionHandler INSTANCE = new PermissionHandler();
    private final Map<ICheckerRegistration, IPermissionChecker> checkers = Maps.newConcurrentMap();

    public static PermissionHandler getInstance() {
        return INSTANCE;
    }

    private PermissionHandler() {
    }

    @Override
    public ICheckerRegistration registerChecker(IPermissionChecker checker) {
        ICheckerRegistration registration = new ICheckerRegistration(){

            @Override
            public void close() {
                PermissionHandler.this.checkers.remove(this);
            }
        };
        this.checkers.put(registration, checker);
        return registration;
    }

    @Override
    public boolean canManipulate(@NotNull Player player, IWorldAreaAccessor worldAreaAccessor) {
        if (this.checkers.size() == 0) {
            return true;
        }
        return this.checkers.values().stream().allMatch(c -> c.isAllowed(player, worldAreaAccessor));
    }
}

