/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client;

import fuzs.diagonalfences.DiagonalFences;
import fuzs.diagonalfences.api.IDiagonalBlock;
import fuzs.diagonalfences.client.model.MultipartAppender;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="diagonalfences", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DiagonalFencesClient {
    @SubscribeEvent
    public static void onModelsBaked(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        ArrayList erroredBlocks = new ArrayList();
        ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof FenceBlock).filter(block -> {
            IDiagonalBlock diag;
            return block instanceof IDiagonalBlock && (diag = (IDiagonalBlock)block).hasProperties();
        }).flatMap(block -> block.m_49965_().m_61056_().stream()).forEach(state -> {
            ModelResourceLocation fenceLocation = BlockModelShaper.m_110895_((BlockState)state);
            BakedModel model = (BakedModel)registry.get(fenceLocation);
            if (model instanceof MultiPartBakedModel) {
                MultiPartBakedModel fenceModel = (MultiPartBakedModel)model;
                MultiPartBakedModel newModel = DiagonalFencesClient.appendDiagonalFenceSelectors(state.m_60734_(), fenceModel);
                registry.put(fenceLocation, newModel);
            } else if (!erroredBlocks.contains(state.m_60734_())) {
                erroredBlocks.add(state.m_60734_());
                DiagonalFences.LOGGER.info(String.format("Fence block '%s' is not using multipart models, diagonal fence connections may not be visible!", state.m_60734_()));
            }
        });
    }

    private static MultiPartBakedModel appendDiagonalFenceSelectors(Block block, MultiPartBakedModel model) {
        Map<BlockState, Direction> oneArmStates = Map.of((BlockState)block.m_49966_().m_61124_((Property)FenceBlock.f_52309_, (Comparable)Boolean.valueOf(true)), Direction.NORTH, (BlockState)block.m_49966_().m_61124_((Property)FenceBlock.f_52310_, (Comparable)Boolean.valueOf(true)), Direction.EAST, (BlockState)block.m_49966_().m_61124_((Property)FenceBlock.f_52311_, (Comparable)Boolean.valueOf(true)), Direction.SOUTH, (BlockState)block.m_49966_().m_61124_((Property)FenceBlock.f_52312_, (Comparable)Boolean.valueOf(true)), Direction.WEST);
        return MultipartAppender.appendDiagonalSelectors(block, oneArmStates, model);
    }
}

