/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import net.pavocado.exoticbirds.ExoticBirdsMod;
import net.pavocado.exoticbirds.block.BirdcageBlock;
import net.pavocado.exoticbirds.blockentity.BirdcageBlockEntity;
import net.pavocado.exoticbirds.capabilities.BirdTracking;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;
import net.pavocado.exoticbirds.client.gui.BirdBookScreen;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsPacketHandler;
import net.pavocado.exoticbirds.network.PacketLogBird;
import net.pavocado.exoticbirds.network.PacketLogBirdcage;
import net.pavocado.exoticbirds.network.PacketSyncCapabilities;

public class BirdBookItem
extends Item {
    public BirdBookItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult blockhitresult = BirdBookItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockhitresult.m_6662_() == HitResult.Type.MISS && !player.m_36341_()) {
            if (level.m_5776_()) {
                this.displayGuiScreen(level, player);
            }
            InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void displayGuiScreen(Level level, Player player) {
        if (level.m_5776_()) {
            Minecraft.m_91087_().m_91152_((Screen)new BirdBookScreen(player));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        Player player = context.m_43723_();
        if (player != null) {
            if (blockstate.m_60734_() instanceof BirdcageBlock) {
                BlockEntity blockEntity;
                if (!level.m_5776_() && (blockEntity = level.m_7702_(blockpos)) instanceof BirdcageBlockEntity) {
                    BirdcageBlockEntity birdcageBlockEntity = (BirdcageBlockEntity)blockEntity;
                    BirdBookItem.logBirdcage(player, birdcageBlockEntity);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!player.m_36341_()) {
                if (level.m_5776_()) {
                    this.displayGuiScreen(level, player);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!playerIn.f_19853_.m_5776_()) {
            BirdBookItem.logBird(playerIn, target);
        }
        return InteractionResult.PASS;
    }

    public static void logBird(Player playerIn, LivingEntity target) {
        if (!playerIn.f_19853_.m_5776_()) {
            playerIn.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> {
                if (target instanceof AbstractBirdEntity) {
                    AbstractBirdEntity birdTarget = (AbstractBirdEntity)target;
                    boolean isNewEntry = BirdBookItem.canBirdBeStoredInCapabilites(cap, playerIn, birdTarget);
                    ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)playerIn), (Object)new PacketLogBird(target.m_142049_(), isNewEntry));
                } else {
                    playerIn.m_6352_((Component)new TranslatableComponent("book.exoticbirds.log_fail").m_130940_(ChatFormatting.RED), Util.f_137441_);
                }
            });
        }
    }

    private static void logBirdcage(Player playerIn, BirdcageBlockEntity birdcage) {
        if (!playerIn.f_19853_.m_5776_()) {
            playerIn.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> {
                Entity target = birdcage.getBirdcageLogic().getOrCreateDisplayEntity(playerIn.f_19853_);
                if (target instanceof AbstractBirdEntity) {
                    AbstractBirdEntity birdTarget = (AbstractBirdEntity)target;
                    boolean isNewEntry = BirdBookItem.canBirdBeStoredInCapabilites(cap, playerIn, birdTarget);
                    ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)playerIn), (Object)new PacketLogBirdcage(birdcage.m_58899_(), isNewEntry));
                } else if (target instanceof LivingEntity) {
                    playerIn.m_6352_((Component)new TranslatableComponent("book.exoticbirds.log_fail").m_130940_(ChatFormatting.RED), Util.f_137441_);
                } else {
                    playerIn.m_6352_((Component)new TranslatableComponent("book.exoticbirds.log_cage_fail").m_130940_(ChatFormatting.RED), Util.f_137441_);
                }
            });
        }
    }

    private static boolean canBirdBeStoredInCapabilites(BirdTracking cap, Player playerIn, AbstractBirdEntity target) {
        if (!cap.getVariants(target.m_6095_()).contains(target.currentVariant())) {
            cap.add(target.m_6095_(), target.currentVariant());
            if (((Boolean)ExoticBirdsCommonConfig.allowBookExperience.get()).booleanValue()) {
                playerIn.f_19853_.m_7967_((Entity)new ExperienceOrb(playerIn.f_19853_, playerIn.m_20185_(), playerIn.m_20186_() + 0.5, playerIn.m_20189_() + 0.5, playerIn.m_21187_().nextInt(7) + 1));
            }
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PacketSyncCapabilities(cap.getAll()));
            }
            return true;
        }
        return false;
    }

    public static void syncLoggedBirds(Player player) {
        LazyOptional birdStorage = player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY);
        if (birdStorage.isPresent()) {
            birdStorage.ifPresent(storage -> ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PacketSyncCapabilities(storage.getAll())));
        } else {
            ExoticBirdsMod.LOGGER.warn("Bird tracking capability for " + player.m_5446_().getString() + " does not exist.");
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("book.exoticbirds.book_tooltip").m_130940_(ChatFormatting.AQUA));
    }
}

