/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.integration.DrawerOverlay;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TheOneProbe
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        if (((Boolean)ClientConfig.INTEGRATION.enableTheOneProbe.get()).booleanValue()) {
            probe.registerProvider((IProbeInfoProvider)new DrawerProbeProvider());
        }
        return null;
    }

    private static class DrawerProbeProvider
    implements IProbeInfoProvider {
        private DrawerProbeProvider() {
        }

        public ResourceLocation getID() {
            return StorageDrawers.rl("drawerprobe");
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probe, Player player, Level world, BlockState blockState, IProbeHitData data) {
            BlockEntity tile = world.m_7702_(data.getPos());
            if (tile instanceof TileEntityDrawers) {
                TileEntityDrawers drawers = (TileEntityDrawers)tile;
                DrawerOverlay overlay = new DrawerOverlay();
                for (Component component : overlay.getOverlay(drawers)) {
                    probe.text(component);
                }
            }
        }
    }
}

