/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.init;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.data.CopyBackpackDataFunction;

public class ModLoot {
    public static final LootItemFunctionType COPY_BACKPACK_DATA = new LootItemFunctionType((Serializer)new CopyBackpackDataFunction.Serializer());
    private static final List<String> CHEST_TABLES = List.of("abandoned_mineshaft", "bastion_treasure", "desert_pyramid", "end_city_treasure", "nether_bridge", "shipwreck_treasure", "simple_dungeon", "woodland_mansion");

    private ModLoot() {
    }

    public static void init(IEventBus modBus) {
        modBus.addGenericListener(Block.class, ModLoot::registerLootFunction);
        MinecraftForge.EVENT_BUS.addListener(ModLoot::lootLoad);
    }

    private static void registerLootFunction(RegistryEvent<Block> event) {
        Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("sophisticatedbackpacks", "copy_backpack_data"), (Object)COPY_BACKPACK_DATA);
    }

    public static void lootLoad(LootTableLoadEvent evt) {
        if (Boolean.FALSE.equals(Config.COMMON.chestLootEnabled.get())) {
            return;
        }
        String chestsPrefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(chestsPrefix) && CHEST_TABLES.contains(name.substring(chestsPrefix.length()))) {
            String file = name.substring("minecraft:".length());
            evt.getTable().addPool(ModLoot.getInjectPool(file));
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return LootPool.m_79043_().m_79076_(ModLoot.getInjectEntry(entryName)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).name("sophisticatedbackpacks_inject_pool").m_79082_();
    }

    private static LootPoolEntryContainer.Builder<?> getInjectEntry(String name) {
        return LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("sophisticatedbackpacks", "inject/" + name)).m_79707_(1);
    }
}

