/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.geheimagentnr1.world_pre_generator.elements.queues.lists.PregenTaskList;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.helpers.JsonHelper;
import de.geheimagentnr1.world_pre_generator.helpers.SaveHelper;
import de.geheimagentnr1.world_pre_generator.save.Savable;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public class PregenTaskQueue
implements Savable<JsonObject> {
    private static final String activeTasksName = "active_tasks";
    private static final String pausedTasksName = "paused_tasks";
    private MinecraftServer server;
    private final PregenTaskList active_tasks = new PregenTaskList();
    private final PregenTaskList paused_tasks = new PregenTaskList();

    public synchronized Optional<PregenTask> getCurrentTask() {
        return this.active_tasks.getFirst();
    }

    public ArrayList<PregenTask> getActiveTasks() {
        return this.active_tasks.getTaskList();
    }

    public ArrayList<PregenTask> getPausedTasks() {
        return this.paused_tasks.getTaskList();
    }

    public boolean isNotEmpty() {
        return !this.active_tasks.isEmpty();
    }

    public boolean noTasks() {
        return this.active_tasks.isEmpty() && this.paused_tasks.isEmpty();
    }

    public synchronized void startTask(PregenTask new_task) {
        this.active_tasks.addOrReplace(new_task);
        this.paused_tasks.removeBy(new_task.getDimension());
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void resumeTask(ResourceKey<Level> dimension) {
        this.paused_tasks.getAndRemoveBy(dimension).ifPresent(this.active_tasks::addOrReplace);
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void pauseTask(ResourceKey<Level> dimension) {
        this.active_tasks.getAndRemoveBy(dimension).ifPresent(this.paused_tasks::addOrReplace);
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void cancelTask(ResourceKey<Level> dimension) {
        this.active_tasks.runFor(dimension, (list, index) -> ((PregenTask)list.get((int)index)).cancel());
        this.paused_tasks.removeBy(dimension);
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void removeCurrentTask() {
        this.active_tasks.removeFirst();
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void clearUp() {
        this.active_tasks.clear();
        this.paused_tasks.clear();
    }

    public synchronized void clear() {
        this.clearUp();
        SaveHelper.saveWorld(this.server);
    }

    @Override
    @Nonnull
    public synchronized JsonObject write() {
        JsonObject json = new JsonObject();
        json.add(activeTasksName, (JsonElement)this.active_tasks.write());
        json.add(pausedTasksName, (JsonElement)this.paused_tasks.write());
        return json;
    }

    @Override
    public synchronized void read(@Nonnull JsonObject json) {
        if (JsonHelper.isJsonArray(json, activeTasksName)) {
            this.active_tasks.read(json.getAsJsonArray(activeTasksName));
        }
        if (JsonHelper.isJsonArray(json, pausedTasksName)) {
            this.paused_tasks.read(json.getAsJsonArray(pausedTasksName));
        }
    }

    public synchronized void setServer(MinecraftServer _server) {
        this.server = _server;
        this.active_tasks.checkTasks(this.server);
        this.paused_tasks.checkTasks(this.server);
    }
}

