/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface KiwiModule {
    public String value() default "core";

    public String dependencies() default "";

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Skip {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface RenderLayer {
        public Layer value();

        public static enum Layer {
            CUTOUT_MIPPED(() -> RenderType::m_110457_),
            CUTOUT(() -> RenderType::m_110463_),
            TRANSLUCENT(() -> RenderType::m_110466_);

            private final Supplier<Supplier<RenderType>> supplier;

            private Layer(Supplier<Supplier<RenderType>> supplier) {
                this.supplier = supplier;
            }

            @OnlyIn(value=Dist.CLIENT)
            public RenderType get() {
                return this.supplier.get().get();
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoItem {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoCategory {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Name {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface LoadingCondition {
        public String[] value() default {""};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Subscriber {
        public Dist[] side() default {Dist.CLIENT, Dist.DEDICATED_SERVER};

        public Bus value() default Bus.FORGE;

        public static enum Bus {
            FORGE(() -> MinecraftForge.EVENT_BUS),
            MOD(() -> FMLJavaModLoadingContext.get().getModEventBus());

            private final Supplier<IEventBus> busSupplier;

            private Bus(Supplier<IEventBus> eventBusSupplier) {
                this.busSupplier = eventBusSupplier;
            }

            public Supplier<IEventBus> bus() {
                return this.busSupplier;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface Category {
        public String value() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Optional {
        public boolean defaultEnabled() default true;
    }
}

