/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.recipes.layout;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.GuiIconButtonSmall;
import mezz.jei.common.gui.ingredients.RecipeSlots;
import mezz.jei.common.gui.recipes.IOnClickHandler;
import mezz.jei.common.gui.recipes.layout.IRecipeLayoutInternal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.recipes.RecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconButtonSmall {
    public static final int RECIPE_BUTTON_SIZE = 13;
    private final IRecipeLayoutInternal<?> recipeLayout;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private IOnClickHandler onClickHandler;

    public RecipeTransferButton(int xPos, int yPos, IDrawable icon, IRecipeLayoutInternal<?> recipeLayout, Textures textures) {
        super(xPos, yPos, 13, 13, icon, b -> {}, textures);
        this.recipeLayout = recipeLayout;
    }

    public void init(RecipeTransferManager recipeTransferManager, @Nullable AbstractContainerMenu container, Player player) {
        this.recipeTransferError = container != null ? RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, this.recipeLayout, player) : RecipeTransferErrorInternal.INSTANCE;
        if (RecipeTransferUtil.allowsTransfer(this.recipeTransferError)) {
            this.f_93623_ = true;
            this.f_93624_ = true;
        } else {
            this.f_93623_ = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.f_93624_ = type == IRecipeTransferError.Type.USER_FACING;
        }
    }

    public void drawToolTip(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (this.recipeTransferError == null) {
                TranslatableComponent tooltipTransfer = new TranslatableComponent("jei.tooltip.transfer");
                TooltipRenderer.drawHoveringText(poseStack, List.of(tooltipTransfer), mouseX, mouseY);
            } else {
                RecipeSlots recipeSlots = this.recipeLayout.getRecipeSlots();
                IRecipeSlotsView recipeSlotsView = recipeSlots.getView();
                this.recipeTransferError.showError(poseStack, mouseX, mouseY, recipeSlotsView, this.recipeLayout.getPosX(), this.recipeLayout.getPosY());
                this.recipeTransferError.showError(poseStack, mouseX, mouseY, this.recipeLayout.getLegacyAdapter(), this.recipeLayout.getPosX(), this.recipeLayout.getPosY());
            }
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.f_93620_ && mouseY >= (double)this.f_93621_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY < (double)(this.f_93621_ + this.f_93619_);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.f_93624_ && this.recipeTransferError != null && this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
            RecipeTransferButton.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-2130729728);
        }
    }

    public void setOnClickHandler(IOnClickHandler onClickHandler) {
        this.onClickHandler = onClickHandler;
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return;
        }
        if (this.onClickHandler != null) {
            this.onClickHandler.onClick(mouseX, mouseY);
        }
    }
}

