/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemGroup
extends CreativeModeTab {
    protected ItemStack icon = ItemStack.f_41583_;
    protected CommonTime.Stamp lastChange = CommonTime.Stamp.now();
    protected CommonTime.Interval changeInterval = CommonTime.Interval.ZERO;
    protected FloatBounds seconds = FloatBounds.of(Float.valueOf(0.0f));

    public ItemGroup(String label) {
        super(label);
    }

    public static ItemGroup labeled(String label) {
        return new ItemGroup(label);
    }

    public ItemGroup icon(Item item) {
        this.icon = new ItemStack((ItemLike)item);
        return this;
    }

    public ItemGroup changeEvery(float minSeconds, float maxSeconds) {
        this.seconds = FloatBounds.between(Float.valueOf(minSeconds), Float.valueOf(maxSeconds));
        this.updateInterval();
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_6976_() {
        return this.icon;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_40787_() {
        if (!this.changeInterval.equals(CommonTime.Interval.ZERO) && CommonTime.Interval.passedFrom(this.lastChange).moreThan(this.changeInterval)) {
            NonNullList items = NonNullList.m_122779_();
            this.m_6151_(items);
            this.icon = CommonCollect.getRandomElementFrom(items).orElse(ItemStack.f_41583_);
            this.lastChange = CommonTime.Stamp.now();
            this.updateInterval();
        }
        return this.icon;
    }

    protected void updateInterval() {
        this.changeInterval = CommonTime.Interval.seconds(this.seconds.randomBetween().floatValue());
    }
}

