/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.generators.textures.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.dark_roleplay.marg.client.generators.textures.generator.TextureGeneratorManipulation;
import net.dark_roleplay.marg.client.generators.textures.generator.processors.TextureProcessorData;
import net.dark_roleplay.marg.client.generators.textures.texture.TextureHolder;
import net.dark_roleplay.marg.client.generators.textures.util.TextureCache;
import net.dark_roleplay.marg.client.generators.textures.util.TextureUtils;
import net.dark_roleplay.marg.client.providers.ClientTextureProvider;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.util.EnumDecoder;
import net.minecraft.resources.ResourceLocation;

public class TextureGeneratorTask {
    public static final Codec<TextureGeneratorTask> CODEC = RecordCodecBuilder.create(i -> i.group((App)InputType.CODEC.fieldOf("inputType").forGetter(TextureGeneratorTask::getInputType), (App)OutputType.CODEC.fieldOf("outputType").forGetter(TextureGeneratorTask::getOutputType), (App)Codec.STRING.fieldOf("inputName").forGetter(TextureGeneratorTask::getInputName), (App)Codec.STRING.fieldOf("outputName").forGetter(TextureGeneratorTask::getOutputName), (App)TextureGeneratorManipulation.CODEC.listOf().fieldOf("manipulations").forGetter(TextureGeneratorTask::getManipulations)).apply((Applicative)i, TextureGeneratorTask::new));
    private final InputType inputType;
    private final OutputType outputType;
    private final String inputName;
    private final String outputName;
    private final List<TextureGeneratorManipulation> manipulations;

    public TextureGeneratorTask(InputType inputType, OutputType outputType, String inputName, String outputName, List<TextureGeneratorManipulation> manipulations) {
        this.inputType = inputType;
        this.outputType = outputType;
        this.inputName = inputName;
        this.outputName = outputName;
        this.manipulations = manipulations;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public String getInputName() {
        return this.inputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public List<TextureGeneratorManipulation> getManipulations() {
        return this.manipulations;
    }

    public void generate(MargMaterial mat, ClientTextureProvider material, Map<String, TextureHolder> textures, TextureCache global, TextureCache localCache) {
        TextureHolder input = null;
        switch (this.inputType) {
            case material: {
                input = material.getTexture(this.inputName).clone();
                break;
            }
            case cache: {
                input = localCache.getCachedTexture(this.inputName).clone();
                break;
            }
            case generator: {
                input = textures.get(this.inputName).clone();
            }
        }
        for (TextureGeneratorManipulation man : this.manipulations) {
            TextureProcessorData data = man.getData();
            data.setTexture(textures, localCache);
            input.applyProcessor(man.getManipulationType().getProcessor(), data);
        }
        switch (this.outputType) {
            case FILE: {
                TextureUtils.writeTexture(new ResourceLocation(mat.getTextProvider().apply(this.outputName)), input);
                break;
            }
            case GLOBAL_CACHE: {
                global.addTexture(this.outputName, input);
                break;
            }
            case LOCAL_CACHE: {
                localCache.addTexture(this.outputName, input);
            }
        }
    }

    static enum InputType {
        none,
        generator,
        material,
        cache;

        private static Codec<InputType> CODEC;

        static {
            CODEC = Codec.STRING.comapFlatMap(new EnumDecoder<InputType>(InputType.class)::decode, Enum::toString).stable();
        }
    }

    static enum OutputType {
        FILE,
        GLOBAL_CACHE,
        LOCAL_CACHE;

        private static Codec<OutputType> CODEC;

        static {
            CODEC = Codec.STRING.comapFlatMap(new EnumDecoder<OutputType>(OutputType.class)::decode, Enum::toString).stable();
        }
    }
}

