/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.listeners;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.dark_roleplay.marg.Marg;
import net.dark_roleplay.marg.client.generators.lang.LangGenerator;
import net.dark_roleplay.marg.common.generators.text.util.TextUtils;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LangReloadListeners
implements PreparableReloadListener {
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LANG_GENERATORS_FOLDER = "marg_generators/lang/";

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        CompletableFuture.runAsync(() -> Minecraft.m_91087_().m_91102_().m_6213_(resourceManager));
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.loadJsons(resourceManager, preparationsProfiler), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(jsons -> this.loadGenerator((Map<ResourceLocation, JsonElement>)jsons, resourceManager, preparationsProfiler), gameExecutor);
    }

    protected Map<ResourceLocation, JsonElement> loadJsons(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        for (ResourceLocation resourceLocation : resourceManager.m_6540_(LANG_GENERATORS_FOLDER, name -> name.endsWith(".json"))) {
            Marg.LOGGER.debug("Loading json File for LangGenerator: '{}' from '{}", (Object)resourceLocation.m_135815_(), (Object)resourceLocation.m_135827_());
            try {
                Resource iresource = resourceManager.m_142591_(resourceLocation);
                try {
                    InputStream inputstream = iresource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (jsonelement != null) {
                            JsonElement jsonelement1 = map.put(resourceLocation, jsonelement);
                            if (jsonelement1 == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + resourceLocation);
                        }
                        LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceLocation, (Object)resourceLocation);
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                finally {
                    if (iresource == null) continue;
                    iresource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceLocation, (Object)resourceLocation, (Object)jsonparseexception);
            }
        }
        return map;
    }

    protected String loadGenerator(Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_6180_("marg");
        profiler.m_6180_("loading");
        profiler.m_6180_("generators");
        HashMap generators = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> generator : objects.entrySet()) {
            Marg.LOGGER.debug("Converting json File to LangGenerator: '{}' from '{}", (Object)generator.getKey().m_135815_(), (Object)generator.getKey().m_135827_());
            JsonElement json = generator.getValue();
            LangGenerator.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(errorMessage -> System.out.println((String)errorMessage)).ifPresent(gen -> generators.put((ResourceLocation)generator.getKey(), gen));
        }
        profiler.m_7238_();
        profiler.m_7238_();
        profiler.m_6180_("processing");
        HashMap<String, String> langEntries = new HashMap<String, String>();
        for (Map.Entry entry2 : generators.entrySet()) {
            Marg.LOGGER.debug("Processing LangGenerator: '{}' from '{}", (Object)((ResourceLocation)entry2.getKey()).m_135815_(), (Object)((ResourceLocation)entry2.getKey()).m_135827_());
            LangGenerator generator = (LangGenerator)entry2.getValue();
            HashSet<MargMaterial> validMaterials = new HashSet<MargMaterial>();
            generator.getCondition().forEach(validMaterials::add);
            langEntries.putAll(generator.generate(resourceManager, validMaterials));
        }
        TextUtils.writeTextFile(new ResourceLocation("marg", "lang/" + Minecraft.m_91087_().f_91066_.f_92075_.toLowerCase() + ".json"), LogicalSide.CLIENT, "{\n" + langEntries.entrySet().stream().map(entry -> String.format("\t\"%s\":\"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining(",\n")) + "\n}");
        profiler.m_7238_();
        profiler.m_7238_();
        return null;
    }
}

