/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemInterfaceBlockEntity
extends BlockEntity {
    public ItemInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ITEM_INTERFACE, pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        IItemHandlerBlock handlerBlock;
        IItemHandlerBlockEntity blockEntity;
        Block block;
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (block = this.m_58900_().m_60734_()) instanceof IItemHandlerBlock && (blockEntity = (handlerBlock = (IItemHandlerBlock)block).getItemHandlerEntity(this.m_58900_(), this.f_58857_, this.f_58858_)) != null) {
            IItemHandler handler = blockEntity.getItemHandler(handlerBlock.getRelativeSide(this.m_58900_(), side));
            if (handler != null) {
                return LazyOptional.of(() -> handler).cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public static interface IItemHandlerBlock {
        public Direction getRelativeSide(BlockState var1, Direction var2);

        public IItemHandlerBlockEntity getItemHandlerEntity(BlockState var1, Level var2, BlockPos var3);

        public static Direction getRelativeSide(Direction facing, Direction side) {
            if (side == null) {
                return side;
            }
            if (side.m_122434_() == Direction.Axis.Y) {
                return side;
            }
            if (facing.m_122434_() == Direction.Axis.Z) {
                facing = facing.m_122424_();
            }
            return Direction.m_122407_((int)(facing.m_122416_() + side.m_122416_()));
        }
    }

    public static interface IItemHandlerBlockEntity {
        public IItemHandler getItemHandler(Direction var1);
    }
}

