/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.bank;

import io.github.lightman314.lightmanscurrency.api.BankAccountLogger;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.notifications.types.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BankAccount {
    private final IMarkDirty markDirty;
    private CoinValue coinStorage = new CoinValue(new CoinValue.CoinValuePair[0]);
    private CoinValue notificationLevel = new CoinValue(new CoinValue.CoinValuePair[0]);
    private BiConsumer<Component, CoinValue> notificationSender;
    private BankAccountLogger logger = new BankAccountLogger();
    private String ownerName = "Unknown";

    public CoinValue getCoinStorage() {
        return this.coinStorage;
    }

    public CoinValue getNotificationValue() {
        return this.notificationLevel;
    }

    public long getNotificationLevel() {
        return this.notificationLevel.getRawValue();
    }

    public void setNotificationValue(CoinValue value) {
        this.notificationLevel = value.copy();
        this.markDirty();
    }

    public void setNotificationConsumer(BiConsumer<Component, CoinValue> notificationSender) {
        this.notificationSender = notificationSender;
    }

    public void pushNotification() {
        if (this.notificationSender != null) {
            this.notificationSender.accept((Component)this.getName(), this.getNotificationValue());
        }
    }

    public static BiConsumer<Component, CoinValue> generateNotificationAcceptor(UUID playerID) {
        return (accountName, value) -> TradingOffice.pushNotification(playerID, new LowBalanceNotification((Component)accountName, (CoinValue)value));
    }

    public BankAccountLogger getLogs() {
        return this.logger;
    }

    public String getOwnersName() {
        return this.ownerName;
    }

    public void updateOwnersName(String ownerName) {
        this.ownerName = ownerName;
    }

    public MutableComponent getName() {
        return new TranslatableComponent("lightmanscurrency.bankaccount", new Object[]{this.ownerName});
    }

    public void depositCoins(CoinValue depositAmount) {
        this.coinStorage = new CoinValue(this.coinStorage.getRawValue() + depositAmount.getRawValue());
        this.markDirty();
    }

    public CoinValue withdrawCoins(CoinValue withdrawAmount) {
        long oldValue = this.coinStorage.getRawValue();
        if (withdrawAmount.getRawValue() > this.coinStorage.getRawValue()) {
            withdrawAmount = this.coinStorage.copy();
        }
        if (withdrawAmount.getRawValue() <= 0L) {
            return CoinValue.EMPTY;
        }
        this.coinStorage.readFromOldValue(this.coinStorage.getRawValue() - withdrawAmount.getRawValue());
        this.markDirty();
        if (oldValue >= this.getNotificationLevel() && this.coinStorage.getRawValue() < this.getNotificationLevel()) {
            this.pushNotification();
        }
        return withdrawAmount;
    }

    public void LogInteraction(Player player, CoinValue amount, boolean isDeposit) {
        this.logger.AddLog(player, amount, isDeposit);
        this.markDirty();
    }

    public void LogInteraction(ITrader trader, CoinValue amount, boolean isDeposit) {
        this.logger.AddLog(trader, amount, isDeposit);
        this.markDirty();
    }

    public void LogTransfer(Player player, CoinValue amount, Component destination, boolean wasReceived) {
        this.logger.AddLog(player, amount, destination, wasReceived);
        this.markDirty();
    }

    public static void DepositCoins(IBankAccountMenu menu, CoinValue amount) {
        if (menu == null) {
            return;
        }
        BankAccount.DepositCoins(menu.getPlayer(), menu.getCoinInput(), menu.getBankAccount(), amount);
    }

    public static void DepositCoins(Player player, Container coinInput, BankAccount account, CoinValue amount) {
        if (account == null) {
            return;
        }
        CoinValue actualAmount = MoneyUtil.getCoinValue(coinInput);
        if (amount.getRawValue() > actualAmount.getRawValue() || amount.getRawValue() <= 0L) {
            amount = actualAmount;
        }
        MoneyUtil.ProcessPayment(coinInput, player, amount, true);
        account.depositCoins(amount);
        account.LogInteraction(player, amount, true);
    }

    public static void WithdrawCoins(IBankAccountMenu menu, CoinValue amount) {
        if (menu == null) {
            return;
        }
        BankAccount.WithdrawCoins(menu.getPlayer(), menu.getCoinInput(), menu.getBankAccount(), amount);
    }

    public static void WithdrawCoins(Player player, Container coinOutput, BankAccount account, CoinValue amount) {
        if (account == null || amount.getRawValue() <= 0L) {
            return;
        }
        CoinValue withdrawnAmount = account.withdrawCoins(amount);
        List<ItemStack> coins = MoneyUtil.getCoinsOfValue(withdrawnAmount);
        for (int i = 0; i < coins.size(); ++i) {
            ItemStack remainder = InventoryUtil.TryPutItemStack(coinOutput, coins.get(i));
            if (remainder.m_41619_() || player.m_36356_(remainder)) continue;
            InventoryUtil.dumpContents(player.f_19853_, player.m_142538_(), remainder);
        }
        account.LogInteraction(player, withdrawnAmount, false);
    }

    public static MutableComponent TransferCoins(IBankAccountAdvancedMenu menu, CoinValue amount, AccountReference destination) {
        return BankAccount.TransferCoins(menu.getPlayer(), menu.getBankAccount(), amount, destination.get());
    }

    public static MutableComponent TransferCoins(Player player, BankAccount fromAccount, CoinValue amount, BankAccount destinationAccount) {
        if (fromAccount == null) {
            return new TranslatableComponent("gui.bank.transfer.error.null.from");
        }
        if (destinationAccount == null) {
            return new TranslatableComponent("gui.bank.transfer.error.null.to");
        }
        if (amount.getRawValue() <= 0L) {
            return new TranslatableComponent("gui.bank.transfer.error.amount", new Object[]{amount.getString("nothing")});
        }
        if (fromAccount == destinationAccount) {
            return new TranslatableComponent("gui.bank.transfer.error.same");
        }
        CoinValue withdrawnAmount = fromAccount.withdrawCoins(amount);
        if (withdrawnAmount.getRawValue() <= 0L) {
            return new TranslatableComponent("gui.bank.transfer.error.nobalance", new Object[]{amount.getString()});
        }
        destinationAccount.depositCoins(withdrawnAmount);
        fromAccount.LogTransfer(player, withdrawnAmount, (Component)destinationAccount.getName().m_130940_(ChatFormatting.GOLD), false);
        destinationAccount.LogTransfer(player, withdrawnAmount, (Component)fromAccount.getName().m_130940_(ChatFormatting.GOLD), true);
        return new TranslatableComponent("gui.bank.transfer.success", new Object[]{withdrawnAmount.getString(), destinationAccount.getName()});
    }

    public BankAccount() {
        this((IMarkDirty)null);
    }

    public BankAccount(IMarkDirty markDirty) {
        this.markDirty = markDirty;
    }

    public BankAccount(CompoundTag compound) {
        this(null, compound);
    }

    public BankAccount(IMarkDirty markDirty, CompoundTag compound) {
        this.markDirty = markDirty;
        this.coinStorage.readFromNBT(compound, "CoinStorage");
        this.logger.read(compound);
        if (compound.m_128441_("OwnerName")) {
            this.ownerName = compound.m_128461_("OwnerName");
        }
        if (compound.m_128441_("NotificationLevel")) {
            this.notificationLevel.readFromNBT(compound, "NotificationLevel");
        }
    }

    public void markDirty() {
        if (this.markDirty != null) {
            this.markDirty.markDirty();
        }
    }

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        this.coinStorage.writeToNBT(compound, "CoinStorage");
        this.logger.write(compound);
        compound.m_128359_("OwnerName", this.ownerName);
        this.notificationLevel.writeToNBT(compound, "NotificationLevel");
        return compound;
    }

    public static AccountReference GenerateReference(Player player) {
        return BankAccount.GenerateReference(player.f_19853_.f_46443_, AccountType.Player, player.m_142081_());
    }

    public static AccountReference GenerateReference(boolean isClient, PlayerReference player) {
        return BankAccount.GenerateReference(isClient, AccountType.Player, player.id);
    }

    public static AccountReference GenerateReference(boolean isClient, Team team) {
        return BankAccount.GenerateReference(isClient, AccountType.Team, team.getID());
    }

    public static AccountReference GenerateReference(boolean isClient, AccountType accountType, UUID id) {
        return new AccountReference(isClient, accountType, id);
    }

    public static AccountReference LoadReference(boolean isClient, CompoundTag compound) {
        AccountType accountType = AccountType.fromID(compound.m_128451_("Type"));
        UUID id = compound.m_128342_("ID");
        return BankAccount.GenerateReference(isClient, accountType, id);
    }

    public static AccountReference LoadReference(boolean isClient, FriendlyByteBuf buffer) {
        try {
            AccountType accountType = AccountType.fromID(buffer.readInt());
            UUID id = buffer.m_130259_();
            return BankAccount.GenerateReference(isClient, accountType, id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static interface IBankAccountMenu {
        public Player getPlayer();

        public Container getCoinInput();

        default public void onDepositOrWithdraw() {
        }

        public boolean isClient();

        default public AccountReference getBankAccountReference() {
            return this.isClient() ? ClientTradingOffice.getLastSelectedAccount() : TradingOffice.getSelectedBankAccount(this.getPlayer());
        }

        default public BankAccount getBankAccount() {
            AccountReference reference = this.getBankAccountReference();
            return reference == null ? null : reference.get();
        }
    }

    public static interface IBankAccountAdvancedMenu
    extends IBankAccountMenu {
        public void setTransferMessage(MutableComponent var1);

        default public void setNotificationLevel(CoinValue amount) {
            BankAccount account = this.getBankAccount();
            if (account != null) {
                account.setNotificationValue(amount);
            }
        }
    }

    public static class AccountReference {
        private final boolean isClient;
        public final AccountType accountType;
        public final UUID id;

        private AccountReference(boolean isClient, AccountType accountType, UUID id) {
            this.isClient = isClient;
            this.accountType = accountType;
            this.id = id;
        }

        public CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("Type", this.accountType.id);
            compound.m_128362_("ID", this.id);
            return compound;
        }

        public void writeToBuffer(FriendlyByteBuf buffer) {
            buffer.writeInt(this.accountType.id);
            buffer.m_130077_(this.id);
        }

        public BankAccount get() {
            switch (this.accountType) {
                case Player: {
                    return this.isClient ? ClientTradingOffice.getPlayerBankAccount(this.id) : TradingOffice.getBankAccount(this.id);
                }
                case Team: {
                    Team team;
                    Team team2 = team = this.isClient ? ClientTradingOffice.getTeam(this.id) : TradingOffice.getTeam(this.id);
                    if (team == null || !team.hasBankAccount()) break;
                    return team.getBankAccount();
                }
            }
            return null;
        }

        public boolean allowedAccess(Player player) {
            switch (this.accountType) {
                case Player: {
                    return player.m_142081_().equals(this.id) || TradingOffice.isAdminPlayer(player);
                }
                case Team: {
                    Team team;
                    Team team2 = team = this.isClient ? ClientTradingOffice.getTeam(this.id) : TradingOffice.getTeam(this.id);
                    if (team == null || !team.hasBankAccount()) break;
                    return team.canAccessBankAccount(player);
                }
            }
            return false;
        }
    }

    public static interface IMarkDirty {
        public void markDirty();
    }

    public static enum AccountType {
        Player(0),
        Team(1);

        public final int id;

        private AccountType(int id) {
            this.id = id;
        }

        public static final AccountType fromID(int id) {
            for (AccountType type : AccountType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return Player;
        }
    }
}

