/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipeSerializer;
import io.github.lightman314.lightmanscurrency.crafting.WalletUpgradeRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="lightmanscurrency", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModRecipes {
    private static final List<RecipeSerializer<?>> RECIPES = new ArrayList();
    public static final RecipeSerializer<WalletUpgradeRecipe> WALLET_UPGRADE = ModRecipes.register("crafting_wallet_upgrade", new WalletUpgradeRecipe.Serializer());
    public static final RecipeSerializer<CoinMintRecipe> COIN_MINT = ModRecipes.register("coin_mint", new CoinMintRecipeSerializer());

    private static <S extends RecipeSerializer<T>, T extends Recipe<?>> S register(String name, S recipeSerializer) {
        recipeSerializer.setRegistryName(new ResourceLocation("lightmanscurrency", name));
        RECIPES.add(recipeSerializer);
        return recipeSerializer;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<RecipeSerializer<?>> event) {
        RECIPES.forEach(recipe -> event.getRegistry().register((IForgeRegistryEntry)recipe));
        RECIPES.clear();
    }
}

